package com.els.base.inquiry.web.controller;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="询报价-询价单-供应商商务条件")
@Controller
@RequestMapping("inquiryBusiCondition")
public class InquiryBusiConditionController {
    @Resource
    protected InquiryBusiConditionService inquiryBusiConditionService;

    @ApiOperation(httpMethod="POST", value="创建询报价-询价单-供应商商务条件")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InquiryBusiCondition inquiryBusiCondition) {
        this.inquiryBusiConditionService.addObj(inquiryBusiCondition);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-询价单-供应商商务条件")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InquiryBusiCondition inquiryBusiCondition) {
        Assert.isNotBlank(inquiryBusiCondition.getId(), "id 为空，保存失败");
        this.inquiryBusiConditionService.modifyObj(inquiryBusiCondition);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-询价单-供应商商务条件")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.inquiryBusiConditionService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-询价单-供应商商务条件")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 InquiryBusiCondition", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<InquiryBusiCondition>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.setPageView(new PageView<InquiryBusiCondition>(pageNo, pageSize));
        
        InquiryBusiConditionExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<InquiryBusiCondition> pageData = this.inquiryBusiConditionService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}