package com.els.base.inquiry.web.controller;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquiryPurFileExample;
import com.els.base.inquiry.service.InquiryPurFileService;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

//@Api(value="询报价-询价单-采购方附件")
//@Controller
@RequestMapping("inquiryPurFile")
public class InquiryPurFileController {
    @Resource
    protected InquiryPurFileService inquiryPurFileService;

    @ApiOperation(httpMethod="POST", value="创建询报价-询价单-采购方附件")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InquiryPurFile inquiryPurFile) {
        this.inquiryPurFileService.addObj(inquiryPurFile);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-询价单-采购方附件")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InquiryPurFile inquiryPurFile) {
        Assert.isNotBlank(inquiryPurFile.getId(), "id 为空，保存失败");
        this.inquiryPurFileService.modifyObj(inquiryPurFile);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-询价单-采购方附件")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.inquiryPurFileService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-询价单-采购方附件")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 InquiryPurFile", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<InquiryPurFile>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        InquiryPurFileExample example = new InquiryPurFileExample();
        example.setPageView(new PageView<InquiryPurFile>(pageNo, pageSize));
        
        InquiryPurFileExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<InquiryPurFile> pageData = this.inquiryPurFileService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}