package com.els.base.inquiry.web.controller;

import java.util.List;

import javax.annotation.Resource;

import com.els.base.inquiry.entity.InquirySupRead;
import com.els.base.inquiry.entity.InquirySupReadExample;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.sup.BatchPublishQuoteCommand;
import com.els.base.inquiry.command.sup.ModifyQuoteCommand;
import com.els.base.inquiry.command.sup.PublishQuoteCommand;
import com.els.base.inquiry.command.sup.SupViewDetailCommand;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.service.InquirySupReadService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-供应商-表头")
@Controller
@RequestMapping("inquirySupOrder")
public class InquirySupOrderController {

	@Resource
	protected InquiryCommandInvoker invoker;
	
    @Resource
    protected InquirySupOrderService inquirySupOrderService;

    @Resource
    protected InquirySupReadService inquirySupReadService;

    @ApiOperation(httpMethod="POST", value="创建询报价-供应商-表头")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InquirySupOrder inquirySupOrder) {
        this.inquirySupOrderService.addObj(inquirySupOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-供应商-表头")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InquirySupOrder inquirySupOrder) {
        Assert.isNotBlank(inquirySupOrder.getId(), "id 为空，保存失败");
        this.inquirySupOrderService.modifyObj(inquirySupOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-供应商-表头")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.inquirySupOrderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-供应商-表头")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 InquirySupOrder", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<InquirySupOrder>> findByPage( 
		@RequestParam(defaultValue="1") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
    	Company company = CompanyUtils.currentCompany();
    	String companyId = company.getId();
        InquirySupOrderExample OrderExample = new InquirySupOrderExample();
        OrderExample.setPageView(new PageView<InquirySupOrder>(pageNo, pageSize));
        OrderExample.setOrderByClause(" PUBLISH_DATE DESC");
        InquirySupOrderExample.Criteria criteria = OrderExample.createCriteria();
        // 供应商查询自己公司的记录，且报价状态属于未报价或重报价的状态
        criteria.andSupCompanyIdEqualTo(companyId);
        //.andQuoteStatusIn(Arrays.asList(new Integer[] {InquiryQuoteStatus.UNQUOTED.getCode(),InquiryQuoteStatus.REQUOTE.getCode()}));
        if (wapper != null) {
            CriteriaUtils.addExample(OrderExample, wapper);
        }

        PageView<InquirySupOrder> pageData = this.inquirySupOrderService.queryObjByPage(OrderExample);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="查看详情界面")
    @RequestMapping("service/supViewDetail")
    @ResponseBody
    public ResponseResult<InquirySupOrder> supViewDetail(@RequestParam(required=true)String supOrderId) {
        InquirySupReadExample example = new InquirySupReadExample();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);

        List<InquirySupRead> inquirySupReads = this.inquirySupReadService.queryAllObjByExample(example);
        if(!CollectionUtils.isNotEmpty(inquirySupReads)){
            ResponseResult<InquirySupOrder> result = new ResponseResult<>();
            result.setCode("201").setMsg("请阅读协议");
            return result;
        }
    	SupViewDetailCommand cmd = new SupViewDetailCommand(supOrderId);
    	InquirySupOrder inquirySupOrder = invoker.invoke(cmd);
		return ResponseResult.success(inquirySupOrder);
    }
    
    @ApiOperation(httpMethod="POST", value="保存报价")
    @RequestMapping("service/saveQuote")
    @ResponseBody
    public ResponseResult<String> saveQuote(@RequestBody InquirySupOrder inquirySupOrder) {
    	ModifyQuoteCommand cmd = new ModifyQuoteCommand(inquirySupOrder);
    	cmd.setSupUser(SpringSecurityUtils.getLoginUser());
    	cmd.setSupCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商发布报价")
    @RequestMapping("service/publishQuote")
    @ResponseBody
    public ResponseResult<String> publishQuote(@RequestBody InquirySupOrder inquirySupOrder) {
    	PublishQuoteCommand cmd = new PublishQuoteCommand(inquirySupOrder);
    	cmd.setSupUser(SpringSecurityUtils.getLoginUser());
    	cmd.setSupCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="供应商批量发布报价")
    @RequestMapping("service/batchPublishQuote")
    @ResponseBody
    public ResponseResult<String> batchPublishQuote(@RequestBody(required=true) List<String> ids) {
    	BatchPublishQuoteCommand cmd = new BatchPublishQuoteCommand(ids);
    	cmd.setSupUser(SpringSecurityUtils.getLoginUser());
    	cmd.setSupCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
}