package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.InquirySupRead;
import com.els.base.inquiry.entity.InquirySupReadExample;
import com.els.base.inquiry.service.InquirySupReadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="询报价-询价单-供应商阅读协议")
@Controller
@RequestMapping("inquirySupRead")
public class InquirySupReadController {
    @Resource
    protected InquirySupReadService inquirySupReadService;

    @ApiOperation(httpMethod = "POST", value = "同意询报价-询价单-供应商阅读协议")
    @RequestMapping("service/markAsRead")
    @ResponseBody
    public ResponseResult<String> markAsRead(@RequestParam(required=true)String supOrderId) {
        Company company = CompanyUtils.currentCompany();
        User user = SpringSecurityUtils.getLoginUser();
        InquirySupRead read = new InquirySupRead();
        read.setSupCompanyId(company.getId());
        read.setSupCompanyName(company.getCompanyName());
        read.setSupCompanySapCode(company.getCompanySapCode());
        read.setSupCompanySrmCode(company.getCompanyCode());
        read.setSupUserId(user.getId());
        read.setSupUserName(user.getNickName());
        read.setCreateTime(new Date());
        read.setSupOrderId(supOrderId);
        inquirySupReadService.addObj(read);
        return ResponseResult.success();
    }
}