package com.els.base.inquiry.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-询价单-供应商")
@Controller
@RequestMapping("inquirySupplier")
public class InquirySupplierController {
	@Resource
	private CompanyService companyService;
	
	@ApiOperation(httpMethod = "POST", value = "查询陌生供应商，潜在供应商，合格供应商、淘汰供应商、受限供应商列表")
	@ApiImplicitParams({ 
		@ApiImplicitParam(name = "roleEnum", required = false, value = "陌生供应商，潜在供应商，合格供应商、淘汰供应商、受限供应商（stranger/potenial/qualified/eliminate/bounded）",paramType = "query", dataType = "String", defaultValue = "stranger"), 
		@ApiImplicitParam(name = "queryParam", required = false, value = "查询参数，可以是SAP编码，可以是srm编码，可以是供应商名称",paramType = "query", dataType = "String"), 
		@ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"), 
		@ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10")
	})
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<Company>> findByPage(
			@RequestParam(defaultValue = "stranger") String roleEnum, 
			@RequestParam String queryParam, 
			@RequestParam(defaultValue = "0") int pageNo, 
			@RequestParam(defaultValue = "10") int pageSize) throws Exception {
		
		// 1.加入供应商查询条件
		CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		
		String purCompanyId = ProjectUtils.getProject().getCompanyId();
		if (StringUtils.isBlank(queryParam)) {
			// 获取采购商ID
			PageView<Company> companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
			return ResponseResult.success(companyPageView);
		}
		
		companyExample.createCriteria().andCompanySapCodeLike("%"+queryParam+"%");
		companyExample.or().andCompanyCodeLike("%"+ queryParam +"%");
		companyExample.or().andCompanyFullNameLike("%"+ queryParam+"%");
		
		for(CompanyExample.Criteria cri : companyExample.getOredCriteria()){
			cri.andProjectIdEqualTo(ProjectUtils.getProjectId())
				.andIsEnableEqualTo(Constant.YES_INT);
		}
		// 获取采购商ID
		PageView<Company> companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
		return ResponseResult.success(companyPageView);
	}
}