package com.els.base.inquiry.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.MaterielParityExample;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.web.vo.MaterielParityVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-同类物料参考比价")
@Controller
@RequestMapping("materielParity")
public class MaterielParityController {
    @Resource
    protected MaterielParityService materielParityService;

    @ApiOperation(httpMethod="POST", value="创建询报价-同类物料参考比价")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MaterielParity materielParity) {
        this.materielParityService.addObj(materielParity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-同类物料参考比价")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MaterielParity materielParity) {
        Assert.isNotBlank(materielParity.getId(), "id 为空，保存失败");
        this.materielParityService.modifyObj(materielParity);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-同类物料参考比价")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.materielParityService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-同类物料参考比价")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 MaterielParity", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<MaterielParity>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        MaterielParityExample example = new MaterielParityExample();
        example.setPageView(new PageView<MaterielParity>(pageNo, pageSize));
        
        MaterielParityExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<MaterielParity> pageData = this.materielParityService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="批量修改询报价-同类物料参考比价")
    @RequestMapping("service/batchModify")
    @ResponseBody
    public ResponseResult<String> batchModify(@RequestBody MaterielParityVo materielParityVo) {
        Assert.isNotNull(materielParityVo, "保存时参数不能为空");
        this.materielParityService.batchModify(materielParityVo);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="GET" , value="根据行ID查询同类物料参考比价信息-同类物料参考比价")
    @RequestMapping("service/findByOrderItemId")
    @ResponseBody
    public ResponseResult<List<MaterielParity>> findByOrderItemId(@RequestParam String orderItemId) {
    	Assert.isNotBlank(orderItemId, "行项目ID不能为空");
    	MaterielParityExample example = new MaterielParityExample();
    	example.createCriteria().andOrderItemIdEqualTo(orderItemId);
    	List<MaterielParity> parityList = materielParityService.queryAllObjByExample(example);
    	return ResponseResult.success(parityList);
    }
}