package com.els.base.inquiry.web.controller;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.MouldDetail;
import com.els.base.inquiry.entity.MouldDetailExample;
import com.els.base.inquiry.service.MouldDetailService;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

//@Api(value="询报价-模具成本分析清单")
//@Controller
@RequestMapping("mouldDetail")
public class MouldDetailController {
    @Resource
    protected MouldDetailService mouldDetailService;

    @ApiOperation(httpMethod="POST", value="创建询报价-模具成本分析清单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MouldDetail mouldDetail) {
        this.mouldDetailService.addObj(mouldDetail);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-模具成本分析清单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MouldDetail mouldDetail) {
        Assert.isNotBlank(mouldDetail.getId(), "id 为空，保存失败");
        this.mouldDetailService.modifyObj(mouldDetail);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-模具成本分析清单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.mouldDetailService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-模具成本分析清单")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 MouldDetail", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<MouldDetail>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        MouldDetailExample example = new MouldDetailExample();
        example.setPageView(new PageView<MouldDetail>(pageNo, pageSize));
        
        MouldDetailExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<MouldDetail> pageData = this.mouldDetailService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}