package com.els.base.inquiry.web.controller;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.KeyAndValueMapConverter;
import com.els.base.utils.excel.TitleAndModelKey;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

@Api(value="询报价-行数据-M001")
@Controller
@RequestMapping("orderItemM001")
public class OrderItemM001Controller {
	
	private static final Logger logger = LoggerFactory.getLogger(OrderItemM001Controller.class);
	
	@Resource
	protected PurOrderService purOrderService;
	
    @Resource
    protected OrderItemM001Service orderItemM001Service;
    
    @Resource
    protected InquiryBusiConditionService inquiryBusiConditionService;

    @ApiOperation(httpMethod="POST", value="查询询报价-行数据-M001")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 OrderItemM001", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<OrderItemM001>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.setPageView(new PageView<OrderItemM001>(pageNo, pageSize));
        
        OrderItemM001Example.Criteria criteria = example.createCriteria();
        criteria.andOperationEqualTo(OperationTypeEnum.ACCEPTED.getCode());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<OrderItemM001> pageData = this.orderItemM001Service.queryForApprovePassOrderByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "POST",value="询报价M001打印")
	@RequestMapping("service/print")
	@ResponseBody
	public ResponseResult<FileData> print(@RequestBody(required=true) List<String> ids){
    	Assert.isNotEmpty(ids, "数据为空");
    	FileData fileData=this.orderItemM001Service.print(ProjectUtils.getProjectId(),CompanyUtils.currentCompanyId(),ids);
		return ResponseResult.success(fileData);
    	
    }
    
    @ApiOperation(httpMethod = "POST",value="询报价行明细批量导出")
    @RequestMapping("service/downloadExcelForItem")
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForItem(@RequestBody(required=false) QueryParamWapper wapper){
    	OrderItemM001Example example = new OrderItemM001Example();
        
        OrderItemM001Example.Criteria criteria = example.createCriteria();
        criteria.andOperationEqualTo(OperationTypeEnum.ACCEPTED.getCode());
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        List<OrderItemM001> itemList = this.orderItemM001Service.queryForApprovePassOrder(example);
        Assert.isNotEmpty(itemList, "报价数据为空");
        

        List<String> orderIds = itemList.stream().map(OrderItemM001::getPurOrderId).collect(Collectors.toList());
        
    	PurOrderExample purOrderExample = new PurOrderExample();
    	purOrderExample.createCriteria().andIdIn(orderIds);
    	List<PurOrder> orderList = this.purOrderService.queryAllObjByExample(purOrderExample);
    	
    	InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
    	busiConditionExample.createCriteria().andPurOrderIdIn(orderIds);
    	List<InquiryBusiCondition> busiConditions = this.inquiryBusiConditionService.queryAllObjByExample(busiConditionExample);
    	
    	List<Map<String, Object>> dataList = itemList.stream().map(item-> {
    		Map<String, Object> data = new HashMap<>();
    		data.put("item", item);
    		
    		PurOrder order = orderList.stream()
    				.filter(tmp-> tmp.getId().equals(item.getPurOrderId()))
    				.findAny().orElse(null);
    		
    		data.put("order", order);
    		
    		InquiryBusiCondition busiCondition = busiConditions.stream()
    				.filter(tmp-> tmp.getPurOrderId().equals(item.getPurOrderId())
    						&& tmp.getSupOrderId().equals(item.getSupOrderId()))
    				.findAny().orElse(null);
    		
    		data.put("busi", busiCondition);
    		
    		return data;
    	}).collect(Collectors.toList());
    	
    	List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
    	FileData fileData;
		try {
			fileData = this.createExcelFileOutputStream(titleAndModelKeys, dataList, "物料报价清单.xml");
		} catch (WriteException | IOException | ParseException e) {
			logger.error("excel 导出失败", e);
			throw new CommonException("excel导出失败");
		}
    	return ResponseResult.success(fileData);
    }
    
    
    @ApiOperation(httpMethod = "POST",value="询报价行明细批量导出")
    @RequestMapping("service/downloadExcel")
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=true) List<String> orderIds){
    	Assert.isNotEmpty(orderIds, "数据为空");
    	
    	OrderItemM001Example example = new OrderItemM001Example();
    	example.createCriteria().andPurOrderIdIn(orderIds);
    	example.setOrderByClause("ORDER_NO ASC, SUP_COMPANY_SAP_CODE ASC, SORT_NO ASC");
    	
    	List<OrderItemM001> itemList = this.orderItemM001Service.queryAllObjByExample(example);
    	Assert.isNotEmpty(itemList, "报价数据为空");
    	
    	PurOrderExample purOrderExample = new PurOrderExample();
    	purOrderExample.createCriteria().andIdIn(orderIds);
    	List<PurOrder> orderList = this.purOrderService.queryAllObjByExample(purOrderExample);
    	
    	InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
    	busiConditionExample.createCriteria().andPurOrderIdIn(orderIds);
    	List<InquiryBusiCondition> busiConditions = this.inquiryBusiConditionService.queryAllObjByExample(busiConditionExample);
    	
    	List<Map<String, Object>> dataList = itemList.stream().map(item-> {
    		Map<String, Object> data = new HashMap<>();
    		data.put("item", item);
    		
    		PurOrder order = orderList.stream()
    				.filter(tmp-> tmp.getId().equals(item.getPurOrderId()))
    				.findAny().orElse(null);
    		
    		data.put("order", order);
    		
    		InquiryBusiCondition busiCondition = busiConditions.stream()
    				.filter(tmp-> tmp.getPurOrderId().equals(item.getPurOrderId())
    						&& tmp.getSupOrderId().equals(item.getSupOrderId()))
    				.findAny().orElse(null);
    		
    		data.put("busi", busiCondition);
    		
    		return data;
    	}).collect(Collectors.toList());
    	
    	List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
    	FileData fileData;
		try {
			fileData = this.createExcelFileOutputStream(titleAndModelKeys, dataList, "物料报价清单.xml");
		} catch (WriteException | IOException | ParseException e) {
			logger.error("excel 导出失败", e);
			throw new CommonException("excel导出失败");
		}
    	return ResponseResult.success(fileData);
    	
    }

	private List<TitleAndModelKey> createExcelHeader() {
		Map<Object, String> isApprovinMap = new HashMap<>();
		isApprovinMap.put(new Integer(1), "未审核");
		isApprovinMap.put(new Integer(2), "正在审核");
		isApprovinMap.put(new Integer(3), "已审核");
		isApprovinMap.put(new Integer(4), "已驳回");
		KeyAndValueMapConverter isApprovingConverter = new KeyAndValueMapConverter(isApprovinMap);
		
//		Map<Object, String> writeBackSapStatusMap = new HashMap<>();
//		writeBackSapStatusMap.put(new Integer(1), "未回写");
//		writeBackSapStatusMap.put(new Integer(2), "成功");
//		writeBackSapStatusMap.put(new Integer(3), "失败");
//		KeyAndValueMapConverter writeBackSapStatusConverter = new KeyAndValueMapConverter(writeBackSapStatusMap);
		
		DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        
        String emptyField = "item.materielParitys";
		
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行号", "item.orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("版本号", emptyField));
        TitleAndModelKey isApprovingKey = ExcelUtils.createTitleAndModelKey("送审状态", "order.auditStatus");
        isApprovingKey.setToStrConverter(isApprovingConverter);
        titleAndModelKeys.add(isApprovingKey);
        
        TitleAndModelKey approvePassTimeKey = ExcelUtils.createTitleAndModelKey("审批通过时间", emptyField); 
        approvePassTimeKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(approvePassTimeKey);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("驳回次数", emptyField));
        TitleAndModelKey writeBackSapStatusKey = ExcelUtils.createTitleAndModelKey("回写信息记录状态", emptyField); 
//        writeBackSapStatusKey.setToStrConverter(writeBackSapStatusConverter);
        titleAndModelKeys.add(writeBackSapStatusKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("回写信息记录失败原因", emptyField));

        TitleAndModelKey writeBackRedLineStatusKey = ExcelUtils.createTitleAndModelKey("回写红线价格状态", emptyField);
//        writeBackRedLineStatusKey.setToStrConverter(writeBackSapStatusConverter);
        titleAndModelKeys.add(writeBackRedLineStatusKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("回写红线价格失败原因", emptyField));

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据编号", "item.orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("核价单用途", "order.materialUsed"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "order.purUserName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商代码", "item.supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "item.supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "item.materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "item.mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "item.name"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("信息类别", "item.infoCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("数量", "item.quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("含税价", "item.taxedUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("不含税价", "item.untaxedUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("第一版提交含税价", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("第一版提交不含税价", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("货币", "busi.currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "item.priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("税码", "busi.taxCode"));
        
        TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey("有效期从", "item.validDateFrom");
        validDateFromKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(validDateFromKey);

        TitleAndModelKey validDateToKey = ExcelUtils.createTitleAndModelKey("有效期到", "item.validDateTo");
        validDateToKey.setToObjConverter(dateConverter);
        validDateToKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(validDateToKey);

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("定价日期控制", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货周期", "item.planDeliveryDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购组", "item.purchaseGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("标准数量", "item.purOrderQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购组织", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("最近一次采购不含税单价", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("降福", "item.decreasingAmplitude"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("参考零部件图号", "item.referPartMapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("参考零部件价格", "item.referPartPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单价格计量单位", emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "item.remark"));
        return titleAndModelKeys;
    }

	private FileData createExcelFileOutputStream(List<TitleAndModelKey> titleAndModelKeys, List<Map<String, Object>> dataList,
			String title) throws RowsExceededException, WriteException, IOException, ParseException {
		FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format(new Date(), "yyyyMMdd");
        fileData.setProjectId(ProjectUtils.getProjectId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format(title+"-{0}", dateStr)+".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays(new Date(),2));
        fileData = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")) , fileData);
        
        FileOutputStream outputStream = new FileOutputStream(fileData.toFile());
        
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, dataList, title, null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return  fileData;
	}
    
}