package com.els.base.inquiry.web.controller;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyDefExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TemplateConfService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-字段定义")
@Controller
@RequestMapping("propertyDef")
public class PropertyDefController {
    @Resource
    protected PropertyDefService propertyDefService;
    
    @Resource
    protected TemplateConfService templateConfService;

    @ApiOperation(httpMethod="POST", value="创建询报价-字段定义")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PropertyDef propertyDef) {
        this.propertyDefService.addObj(propertyDef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-字段定义")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PropertyDef propertyDef) {
        Assert.isNotBlank(propertyDef.getId(), "id 为空，保存失败");
        this.propertyDefService.modifyObj(propertyDef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-字段定义")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.propertyDefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-字段定义")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 PropertyDef", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<PropertyDef>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        PropertyDefExample example = new PropertyDefExample();
        example.setPageView(new PageView<PropertyDef>(pageNo, pageSize));
        
        PropertyDefExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<PropertyDef> pageData = this.propertyDefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    /*@ApiOperation(httpMethod="POST", value="查询询价单行的定义字段")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "templateConfId",required = false,value = "模板id", paramType = "query", dataType = "String"),  
	}) 
    @RequestMapping("service/findOrderItemPropertyDef")
    public ResponseResult<List<PropertyDef>> findOrderItemPropertyDef(String templateConfId){
    	
    	if (StringUtils.isBlank(templateConfId)) {
    		List<PropertyDef> list = PropertyDefUtils.getProperyDefByClass(InquiryConstant.DEFALUT_ORDER_TIEM_CLS);
			return ResponseResult.success(list);
		}
    	
    	List<PropertyDef> list = this.propertyDefService.queryOrderItemPropertyDefListByTplId(templateConfId);
    	return ResponseResult.success(list);
    }*/
    
    
}