package com.els.base.inquiry.web.controller;

import java.math.BigDecimal;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ApproveSubmitCommand;
import com.els.base.inquiry.command.pur.BatchDeleteCommand;
import com.els.base.inquiry.command.pur.BatchPublishCommand;
import com.els.base.inquiry.command.pur.BatchReQuoteCommand;
import com.els.base.inquiry.command.pur.CancelCommand;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.command.pur.ModifyCommand;
import com.els.base.inquiry.command.pur.PreviewCommand;
import com.els.base.inquiry.command.pur.PreviewMouldListCommand;
import com.els.base.inquiry.command.pur.PreviewTargeListCommand;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.command.pur.PublishCommand;
import com.els.base.inquiry.command.pur.RecallCommand;
import com.els.base.inquiry.command.pur.ViewDetailCommand;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.inquiry.web.vo.MouldTransformVo;
import com.els.base.inquiry.web.vo.ReQuoteVo;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-采购方-表头")
@Controller
@RequestMapping("purOrder")
public class PurOrderController {
	
	@Resource
	protected InquiryCommandInvoker invoker;
	
    @Resource
    protected PurOrderService purOrderService;
    
    @Resource
    private InquiryWaitMaterialService inquiryWaitMaterialService;
    @Resource
    private TemplateConfService templateConfService;

    @ApiOperation(httpMethod="POST", value="创建询报价-采购方-表头")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurOrder purOrder) {
    	CreateCommand cmd = new CreateCommand(purOrder);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	
    	this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-采购方-表头")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurOrder purOrder) {
        Assert.isNotBlank(purOrder.getId(), "id 为空，保存失败");
        ModifyCommand cmd = new ModifyCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-采购方-表头")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.purOrderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-采购方-表头")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 PurOrder", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<PurOrder>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        PurOrderExample example = new PurOrderExample();
        example.setPageView(new PageView<PurOrder>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_DATE DESC");
        example.createCriteria().andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        
        PurOrderExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<PurOrder> pageData = this.purOrderService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @SuppressWarnings({ "rawtypes", "unchecked" })
	@ApiOperation(httpMethod="POST", value="查询询报价详情")
    @ApiImplicitParams({ 
    	@ApiImplicitParam( name = "id",required = false,value = "询价单id", paramType = "query", dataType = "String", defaultValue = "0" )
    }) 
    @RequestMapping("service/findById")
    @ResponseBody
    public ResponseResult<PurOrder> findById(@RequestParam(required=true) String id) {
    	PurOrder order = this.purOrderService.queryObjById(id);
    	Assert.isNotNull(order, "询价单不存在");
    	
    	return this.viewPricingDetail(id);
    }
    
    @ApiOperation(httpMethod="POST", value="预览表头")
    @RequestMapping("service/preview")
    @ResponseBody
    public ResponseResult<PurOrder> preview(@RequestBody(required=true) WaitMaterialTransformVo vo) {
    	
    	PreviewCommand cmd = new PreviewCommand(vo.getTemplateId(), vo.getInquiryWaitMaterials(),vo.getMaterialUsesCode());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	PurOrder order = invoker.invoke(cmd);
		return ResponseResult.success(order);
    }
    
    @ApiOperation(httpMethod="POST", value="预览表行")
    @RequestMapping("service/previewTarget")
    @ResponseBody
    public ResponseResult<List<ITarget>> previewTarget(@RequestBody(required=true) WaitMaterialTransformVo vo) {
    	
    	PreviewTargeListCommand cmd = new PreviewTargeListCommand(vo.getTemplateId(), vo.getInquiryWaitMaterials());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
    	return ResponseResult.success(invoker.invoke(cmd));
    }
    
    @ApiOperation(httpMethod="POST", value="预览表行")
    @RequestMapping("service/previewMould")
    @ResponseBody
    public ResponseResult<List<IMould>> previewMould(@RequestBody(required=true) MouldTransformVo vo) {
    	
    	PreviewMouldListCommand cmd = new PreviewMouldListCommand(vo.getTemplateId(), vo.getMouldList());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
    	return ResponseResult.success(invoker.invoke(cmd));
    }
    
    @ApiOperation(httpMethod="POST", value="查看详情界面")
    @RequestMapping("service/viewDetail")
    @ResponseBody
    public ResponseResult<PurOrder> viewDetail(@RequestParam(required=true)String purOrderId) {
    	ViewDetailCommand cmd = new ViewDetailCommand(purOrderId);
//    	ViewPricingDetailCommand cmd = new ViewPricingDetailCommand(purOrderId);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	PurOrder order = invoker.invoke(cmd);
		return ResponseResult.success(order);
    }
    
    @ApiOperation(httpMethod="POST", value="发布询价单")
    @RequestMapping("service/publish")
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody PurOrder purOrder) {
    	PublishCommand cmd = new PublishCommand(purOrder);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	this.invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量发布询价单")
    @RequestMapping("service/batchPublish")
    @ResponseBody
    public ResponseResult<String> batchPublish(@RequestBody(required=true) List<String> ids) {
    	BatchPublishCommand cmd = new BatchPublishCommand(ids);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	this.invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="采购方批量撤回询价单")
    @RequestMapping("service/batchRecall")
    @ResponseBody
    public ResponseResult<String> batchRecall(@RequestBody(required=true) List<String> ids) {
    	RecallCommand cmd = new RecallCommand(ids);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	this.invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="采购方批量作废询价单")
    @RequestMapping("service/batchCancel")
    @ResponseBody
    public ResponseResult<String> batchCancel(@RequestBody(required=true) List<String> ids) {
    	CancelCommand cmd = new CancelCommand(ids);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	this.invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="采购方批量删除询价单")
    @RequestMapping("service/batchDelete")
    @ResponseBody
    public ResponseResult<String> batchDelete(@RequestBody(required=true) List<String> ids) {
    	BatchDeleteCommand cmd = new BatchDeleteCommand(ids);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	this.invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="查看定价详情界面")
    @RequestMapping("service/viewPricingDetail")
    @ResponseBody
    public ResponseResult<PurOrder> viewPricingDetail(@RequestParam(required=true)String purOrderId) {
    	ViewPricingDetailCommand cmd = new ViewPricingDetailCommand(purOrderId);
    	PurOrder purOrder = invoker.invoke(cmd);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
		return ResponseResult.success(purOrder);
    }
    
    @ApiOperation(httpMethod="POST", value="定价操作")
    @RequestMapping("service/pricing")
    @ResponseBody
    public ResponseResult<String> pricing(@RequestBody(required=true)PurOrder purOrder) {
    	PricingCommand cmd = new PricingCommand(purOrder);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量执行重报价操作")
    @RequestMapping("service/batchReQuote")
    @ResponseBody
    public ResponseResult<String> batchReQuote(@RequestBody(required=true)ReQuoteVo reQuoteVo) {
    	BatchReQuoteCommand cmd = new BatchReQuoteCommand(reQuoteVo);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="提交审批")
    @RequestMapping("service/submitToApprove")
    @ResponseBody
    public ResponseResult<String> submitToApprove(@RequestBody(required=true)ApproveSubmitVo vo) {
    	ApproveSubmitCommand cmd = new ApproveSubmitCommand(vo);
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	invoker.invoke(cmd);
		return ResponseResult.success();
    }
    
//    @ApiOperation(httpMethod="POST", value="下载导入模板")
//    @RequestMapping("service/downloadExcel")
//    @ResponseBody
//    public String downloadExcel(@RequestParam(required=true) String templateId, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException{
//
//    	String fileName = String.format("物料清单模板%s.xls", DateFormatUtils.format(new Date(), "yyyyMMdd"));
//    	
//		StringBuffer header = new StringBuffer("attachment;");
//		header.append("filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\";");
//		response.setHeader("Content-Disposition", header.toString());
//
//		response.setCharacterEncoding("UTF-8");
//		response.setContentType("application/octet-stream;charset=UTF-8");
//    	OrderItemExcelUtils.export(templateId, response.getOutputStream());
//    	return null;
//    }
//    
//    @ApiOperation(httpMethod="POST", value="下载导入模板")
//    @RequestMapping("service/uploadForImportExcel")
//    @ResponseBody
//    public ResponseResult<List<? extends ITarget>> uploadForImportExcel(@RequestParam(required=true) String templateId, MultipartHttpServletRequest request) throws Exception{
//    	Map<String, MultipartFile> fileMap = request.getFileMap();
//
//    	if (MapUtils.isEmpty(fileMap)) {
//			throw new CommonException("上传文件为空", "file_isNull");
//		}
//		if (fileMap.size() > 1) {
//			throw new CommonException("只接受单个文件导入");
//		}
//
//		MultipartFile file = fileMap.entrySet().iterator().next().getValue();
//
//    	return ResponseResult.success(OrderItemExcelUtils.importFromExcel(templateId, file.getInputStream()));
//    }
    
    @ApiOperation(httpMethod="POST", value="计算不含税价格")
    @RequestMapping("service/calculateItemDetail")
    @ResponseBody
    public ResponseResult<BigDecimal> calculateItemDetail(@RequestParam(required=true) String templateId,  @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException{
    	
    	TemplateConf templateConf = this.templateConfService.queryObjById(templateId);
    	DetailDeSerializer<? extends IOrderItemDetail > serializer = new DetailDeSerializer<>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
    	
    	IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
    	return ResponseResult.success(itemDetail.calculate());
    }
    
    @ApiOperation(httpMethod="POST", value="计算不含税价格")
    @RequestMapping("service/calculateItemDetailValue")
    @ResponseBody
    public ResponseResult<List<PropertyValue>>  calculateItemDetailValue(@RequestParam(required=true) String templateId,  @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException{
    	
    	TemplateConf templateConf = this.templateConfService.queryObjById(templateId);
    	DetailDeSerializer<? extends IOrderItemDetail > serializer = new DetailDeSerializer<>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
    	
    	IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
    	itemDetail.calculate();
    	itemDetail.setTemplateId(templateId);
    	DetailSerialzer<IOrderItemDetail> serialzer = new DetailSerialzer<>();
    	return ResponseResult.success(serialzer.getProperyValueClass(itemDetail));
    }

    @ApiOperation(httpMethod="POST", value="询报价报表查询")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
            @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 PurOrder", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findReportByPage")
    @ResponseBody
    public ResponseResult<PageView<PurOrder>> findReportByPage(
            @RequestParam(defaultValue="0") int pageNo,
            @RequestParam(defaultValue="10") int pageSize,
            @RequestBody(required=false) QueryParamWapper wapper) {
        PurOrderExample example = new PurOrderExample();
        example.setPageView(new PageView<PurOrder>(pageNo, pageSize));
        example.setOrderByClause(" CREATE_DATE DESC");

        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }

        PageView<PurOrder> pageData = this.purOrderService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}