package com.els.base.inquiry.web.controller;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.TargetM001;
import com.els.base.inquiry.entity.TargetM001Example;
import com.els.base.inquiry.service.TargetM001Service;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

//@Api(value="询报价-询价单-M001物料清单")
//@Controller
@RequestMapping("targetM001")
public class TargetM001Controller {
    @Resource
    protected TargetM001Service targetM001Service;

    @ApiOperation(httpMethod="POST", value="创建询报价-询价单-M001物料清单")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TargetM001 targetM001) {
//        this.targetM001Service.addObj(targetM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-询价单-M001物料清单")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TargetM001 targetM001) {
        Assert.isNotBlank(targetM001.getId(), "id 为空，保存失败");
        this.targetM001Service.modifyObj(targetM001);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-询价单-M001物料清单")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.targetM001Service.deleteObjById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="删除询报价-询价单-M001物料清单")
    @RequestMapping("service/findById")
    @ResponseBody
    public ResponseResult<TargetM001> findById(@RequestParam(required=true) String id) {
    	Assert.isNotBlank(id, "删除失败,id不能为空");
    	TargetM001 tarege = this.targetM001Service.queryObjById(id);
     	List<PropertyValue> propertyValueList = new ArrayList<>();
     	PropertyValue propertyValue = new PropertyValue();
     	propertyValue.setCode("field1");
     	propertyValue.setValueStr("1514822520000");
     	propertyValue.setType("date");
		propertyValueList.add(propertyValue );
		tarege.setPropertyValueList(propertyValueList);
    	return ResponseResult.success(tarege);
    }
    
    

    @ApiOperation(httpMethod="POST", value="查询询报价-询价单-M001物料清单")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 TargetM001", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<TargetM001>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        TargetM001Example example = new TargetM001Example();
        example.setPageView(new PageView<TargetM001>(pageNo, pageSize));
        
        TargetM001Example.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<TargetM001> pageData = this.targetM001Service.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    /*@ApiOperation(value = "询报价，导入Excel(竖版)", httpMethod = "POST")
	@RequestMapping(value = "service/importExcel")
	@ResponseBody
	public ResponseResult<List<TargetM001>> importExcel(MultipartHttpServletRequest request)  {
    	Map<String, MultipartFile> fileMap = request.getFileMap();
		MultipartFile file = this.vaildFile(fileMap);
		
		List<TitleAndModelKey> titleAndModelKeys = this.targetM001Service.createExcelHeaderVer();
		List<TargetM001> list;
		
		try {
			list = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0, titleAndModelKeys,
					TargetM001.class);
			if (CollectionUtils.isEmpty(list)) 
				throw new CommonException("没有数据,无需导入!");
		} catch (Exception e) {
			e.printStackTrace();
			throw new CommonException("导入异常：" + e.getMessage());
		}
    	
    	return ResponseResult.success(list);
    }

	private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
		if (MapUtils.isEmpty(fileMap)) {
			throw new CommonException("上传文件为空", "file_isNull");
		}
		if (fileMap.size() > 1) {
			throw new CommonException("只接受单个文件导入");
		}

		Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

		Iterator<String> keyIterator = fileKeySet.iterator();
		MultipartFile file = null;
		while (keyIterator.hasNext()) {
			file = fileMap.get(keyIterator.next());
		}
		return file;
	}*/
	
//	@ApiOperation(value = "询报价，导出Excel(竖版)", httpMethod = "POST")
//	@RequestMapping(value = "service/uploadExcel")
//	@ResponseBody
//	public ResponseResult<FileData> uploadExcel() throws WriteException, IOException, ParseException, Exception{
//		FileData fileData = this.targetM001Service.downloadExcel();
//		
//		return ResponseResult.success(fileData);
//	}
}