package com.els.base.inquiry.web.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateTemplateConfCmd;
import com.els.base.inquiry.command.template.DeleteTemplateConfCmd;
import com.els.base.inquiry.command.template.ModifyTemplateConfCmd;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-模板配置信息")
@Controller
@RequestMapping("templateConf")
public class TemplateConfController {
    @Resource
    protected TemplateConfService templateConfService;

    @Resource
    private InquiryCommandInvoker invoker;

    @Resource
	private TplMouldDetailService tplMouldDetailService;

    @Resource
	private TplOrderItemDetailService tplOrderItemDetailService;

    @ApiOperation(httpMethod="POST", value="创建询报价-模板配置信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TemplateConf templateConf) {
    	CreateTemplateConfCmd cmd = new CreateTemplateConfCmd(templateConf);
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-模板配置信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TemplateConf templateConf) {
        Assert.isNotBlank(templateConf.getId(), "id 为空，保存失败");
        
        ModifyTemplateConfCmd cmd = new ModifyTemplateConfCmd(templateConf);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-模板配置信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, "删除失败,模板数据不能为空");
        DeleteTemplateConfCmd cmd = new DeleteTemplateConfCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-模板配置信息")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 TemplateConf", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<TemplateConf>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        TemplateConfExample example = new TemplateConfExample();
        example.setPageView(new PageView<TemplateConf>(pageNo, pageSize));
        
        TemplateConfExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        example.setOrderByClause("CREATE_TIME DESC");
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<TemplateConf> pageData = this.templateConfService.queryObjByPage(example);
        pageData.getQueryResult().forEach(templateConf->{
        	templateConf.setOrderItemPropertyDefList(PropertyDefUtils.queryOrderItemProDef(templateConf));
        	
        	if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
        		templateConf.setMouldPropertyDefList(PropertyDefUtils.queryMouldProDef(templateConf));
    		}
        	if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
        		templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.queryBusiConditionProDef(templateConf));
    		}
        	if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())
        			&& StringUtils.isNotBlank(templateConf.getMouldItemDtlTplId())) {
        		templateConf.setTplMouLdDetail(this.tplMouldDetailService.queryObjById(templateConf.getMouldItemDtlTplId()));
    		}
        	if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())
        			&& StringUtils.isNotBlank(templateConf.getOrderItemDtlTplId())) {
    			templateConf.setTplOrderItemDetail(this.tplOrderItemDetailService.queryObjById(templateConf.getOrderItemDtlTplId()));
    		}
        });
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="根据Id查询询报价-模板配置信息")
    @RequestMapping("service/findById")
    @ResponseBody
    public ResponseResult<TemplateConf> findById(@RequestParam(required=true) String id) {
    	
    	TemplateConf templateConf = this.templateConfService.queryObjById(id);
    	Assert.isNotNull(templateConf, "数据不存在，请刷新后重试");
    	
    	return ResponseResult.success(templateConf);
    }
    
    @ApiOperation(httpMethod="GET", value="询报价-模具成本清单模板创建预览")
    @RequestMapping("service/preview")
    @ResponseBody
    public ResponseResult<TemplateConf> preview(){
    	
    	TemplateConf templateConf = new TemplateConf();
    	String dateFormat = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
    	templateConf.setCode(String.format("TPL_CONF_%s", dateFormat));
    	templateConf.setName(String.format("询价单模板_%s", dateFormat));
    	
    	templateConf.setIsAttachmentEnable(Constant.YES_INT);
    	templateConf.setIsBusiCondEnable(Constant.YES_INT);
    	templateConf.setIsLadderPriceEnable(Constant.NO_INT);
    	templateConf.setIsMouldEnable(Constant.NO_INT);
    	templateConf.setIsMouldDetailEnable(Constant.NO_INT);
    	templateConf.setIsOrderItemDetailEnable(Constant.NO_INT);
    	
    	templateConf.setOrderItemPropertyDefList(PropertyDefUtils.getProperyDefByClass(templateConf.getOrderItemClass()));
    	templateConf.setMouldPropertyDefList(PropertyDefUtils.getProperyDefByClass(templateConf.getMouldClass()));
    	templateConf.setBusiConditionPropertyDefList(PropertyDefUtils.getProperyDefByClass(templateConf.getBusiConditionClass()));
    	
    	templateConf.setTargetClassName(InquiryConstant.DEFALUT_TARGET_CLS.getName());
    	templateConf.setTargetServiceClassName(InquiryConstant.DEFALUT_TARGET_SERVICE_CLS.getName());
    	
    	templateConf.setItemClassName(InquiryConstant.DEFALUT_ORDER_TIEM_CLS.getName());
    	templateConf.setItemServiceClassName(InquiryConstant.DEFALUT_ORDER_TIEM_SERVICE_CLS.getName());
    	
    	templateConf.setBusiCondClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_CLS.getName());
    	templateConf.setBusiCondServiceClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_SERVICE_CLS.getName());
    	
    	templateConf.setMouldServiceClassName(InquiryConstant.DEFALUT_MOULD_CLS.getName());
    	templateConf.setMouldServiceClassName(InquiryConstant.DEFALUT_MOULD_SERVICE_CLS.getName());
    	
    	return ResponseResult.success(templateConf);
    }
}