package com.els.base.inquiry.web.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateMouldDetailTplCmd;
import com.els.base.inquiry.command.template.DeleteMouldDetailTplCmd;
import com.els.base.inquiry.command.template.ModifyMouldDetailTplCmd;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-模具成本清单模板")
@Controller
@RequestMapping("tplMouldDetail")
public class TplMouldDetailController {
    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    
    @Resource
    protected PropertyDefService propertyDefService;
    
    @Resource
    private InquiryCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="创建询报价-模具成本清单模板")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TplMouldDetail tplMouLdDetail) {
    	CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(tplMouLdDetail);
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
        return ResponseResult.success(invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-模具成本清单模板")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TplMouldDetail tplMouLdDetail) {
        Assert.isNotBlank(tplMouLdDetail.getId(), "id 为空，保存失败");
        ModifyMouldDetailTplCmd cmd = new ModifyMouldDetailTplCmd(tplMouLdDetail);

    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
        return ResponseResult.success(invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-模具成本清单模板")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, "删除失败,id不能为空");
        
        DeleteMouldDetailTplCmd cmd = new DeleteMouldDetailTplCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        
        return ResponseResult.success();
    }
    
    
    @ApiOperation(httpMethod="GET", value="询报价-模具成本清单模板创建预览")
    @ApiImplicitParams({ 
    	@ApiImplicitParam( name = "className",required = false,value = "模板指定类名(非必填)", paramType = "query", dataType = "String", defaultValue = "0" )
    })
    @RequestMapping("service/preview")
    @ResponseBody
    public ResponseResult<TplMouldDetail> preview(String className){
    	Class clazz = null;
    	if (StringUtils.isNotBlank(className)) {
			clazz = ClassReflectionUtils.getClassByName(className);
		}else {
			clazz = InquiryConstant.DEFALUT_MOULD_DETAIL_CLS;
		}
    	
    	TplMouldDetail tplMouLdDetail = new TplMouldDetail();
    	String dateFormat = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
    	tplMouLdDetail.setCode(String.format("TPL_MOULD_DETAIL_%s", dateFormat));
    	tplMouLdDetail.setName(String.format("模具成本清单%s", dateFormat));
    	tplMouLdDetail.setPropertyDefList(PropertyDefUtils.getProperyDefByClass(clazz));
    	return ResponseResult.success(tplMouLdDetail);
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-模具成本清单模板")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 TplMouLdDetail", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<TplMouldDetail>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        TplMouldDetailExample example = new TplMouldDetailExample();
        example.setPageView(new PageView<TplMouldDetail>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        TplMouldDetailExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<TplMouldDetail> pageData = this.tplMouldDetailService.queryObjByPage(example);
        for (TplMouldDetail tplMouldDetail : pageData.getQueryResult()) {
        	tplMouldDetail.setPropertyDefList(PropertyDefUtils.queryMouldDetailProDef(tplMouldDetail));
		}
        return ResponseResult.success(pageData);
    }

}