package com.els.base.inquiry.web.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateOrderItemDetailTplCmd;
import com.els.base.inquiry.command.template.DeleteOrderItemDetailTplCmd;
import com.els.base.inquiry.command.template.ModifyOrderItemDetailTplCmd;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="询报价-物料成本清单模板")
@Controller
@RequestMapping("tplOrderItemDetail")
public class TplOrderItemDetailController {
    @Resource
    protected TplOrderItemDetailService tplOrderItemDetailService;
    
    @Resource
    protected PropertyDefService propertyDefService;
    
    @Resource
    private InquiryCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="创建询报价-物料成本清单模板")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TplOrderItemDetail tplOrderItemDetail) {
    	CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(tplOrderItemDetail);
    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
    	
        return ResponseResult.success(invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="编辑询报价-物料成本清单模板")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TplOrderItemDetail tplOrderItemDetail) {
        Assert.isNotBlank(tplOrderItemDetail.getId(), "id 为空，保存失败");
        ModifyOrderItemDetailTplCmd cmd = new ModifyOrderItemDetailTplCmd(tplOrderItemDetail);

    	cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="删除询报价-物料成本清单模板")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, "删除失败,模板数据不能为空");
//        this.tplOrderItemDetailService.deleteObjById(id);
        DeleteOrderItemDetailTplCmd cmd = new DeleteOrderItemDetailTplCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
    	cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询询报价-物料成本清单模板")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 TplOrderItemDetail", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<TplOrderItemDetail>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        TplOrderItemDetailExample example = new TplOrderItemDetailExample();
        example.setPageView(new PageView<TplOrderItemDetail>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        TplOrderItemDetailExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<TplOrderItemDetail> pageData = this.tplOrderItemDetailService.queryObjByPage(example);
        for (TplOrderItemDetail tplOrderItemDetail : pageData.getQueryResult()) {
			tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.queryOrderItemDetailProDef(tplOrderItemDetail));
		}
        return ResponseResult.success(pageData);
    }
    @ApiOperation(httpMethod="GET", value="询报价-物料成本清单模板-创建预览")
    @ApiImplicitParams({ 
    	@ApiImplicitParam( name = "className",required = false,value = "模板指定类名(非必填)", paramType = "query", dataType = "String", defaultValue = "0" )
    })
    @RequestMapping("service/preview")
    @ResponseBody
    public ResponseResult<TplOrderItemDetail> preview(String className) throws InstantiationException, IllegalAccessException{
    	Class<? extends IOrderItemDetail> clazz = null;
    	if (StringUtils.isNotBlank(className)) {
			clazz = ClassReflectionUtils.getClassByName(className);
		}else {
			clazz = InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_CLS;
		}
    	
    	TplOrderItemDetail tplOrderItemDetail = new TplOrderItemDetail();
    	String dateFormat = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
    	tplOrderItemDetail.setCode(String.format("TPL_ORDER_ITEM_DETAIL_%s", dateFormat));
    	tplOrderItemDetail.setName(String.format("物料成本清单%s", dateFormat));
    	tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.getProperyDefByClass(clazz));
    	tplOrderItemDetail.setOrderDtlClassName(clazz.getName());
    	tplOrderItemDetail.setOrderDtlServiceName(clazz.newInstance().getItemDetailService().getName());
    	return ResponseResult.success(tplOrderItemDetail);
    }
}