/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.event.ApprovePassListener;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ApproveSubmitCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;
    private Boolean isOpen = true;

    public ApproveSubmitCommand(ApproveSubmitVo vo) {
        this.purOrder = vo.getPurOrder();
    }

    public ApproveSubmitCommand(ApproveSubmitVo vo, Boolean isOpen) {
        this.purOrder = vo.getPurOrder();
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.vaild(this.purOrder);
        PricingCommand pricingCommand = new PricingCommand(this.purOrder);
        pricingCommand.copyProperties(this);
        invoker.invoke(pricingCommand);
        this.logger.info("\u8bb0\u5f55\u91c7\u8d2d\u65b9\u7684\u63a5\u53d7\u6216\u62d2\u7edd\u64cd\u4f5c");
        this.purOrder.getItemList().stream().filter(item -> OperationTypeEnum.isPricingOperation(item.getOperation())).forEach(item -> {
            OrderItemM001 data = (OrderItemM001)item;
            this.validOrderItem(data);
            TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.purOrder.getTemplateId());
            try {
                IOrderItem tmpItem = templateConf.getOrderItemClass().newInstance();
                tmpItem.setId(item.getId());
                tmpItem.setOperation(item.getOperation());
                templateConf.getOrderItemService().modifyStatus(tmpItem);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
        this.logger.info("\u5c06\u91c7\u8d2d\u65b9\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5ba1\u6279\u4e2d\u201d\u72b6\u6001");
        PurOrder temp = new PurOrder();
        temp.setId(this.purOrder.getId());
        temp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
        invoker.getPurOrderService().modifyObj(temp);
        this.logger.info("\u5c06\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5df2\u51bb\u7ed3\u201d\u72b6\u6001");
        this.transformSupOrderToFrozen(this.purOrder);
        this.logger.info("\u63d0\u4ea4\u8be2\u4ef7\u5355\u5ba1\u6838\uff0c\u5f00\u542f\u5ba1\u6279\u6d41");
        String displayPage = String.format("inquiryBillManagerPur?id=%s", this.purOrder.getId());
        ProcessStartVO vo = null;
        ProcessInstance startProcess = null;
        if (this.isOpen.booleanValue()) {
            vo = StringUtils.isNotBlank((String)this.purOrder.getMaterialUsed()) ? ProcessStartVO.newInstance((String)this.purOrder.getMaterialUsed().trim(), (String)this.purOrder.getOrderNo(), (String)this.purOrder.getId(), (String)displayPage) : ProcessStartVO.newInstance((String)"xjdgl", (String)this.purOrder.getOrderNo(), (String)this.purOrder.getId(), (String)displayPage);
            vo.setListenerClass(ApprovePassListener.class);
            startProcess = invoker.getWorkFlowService().startProcess(vo);
        } else {
            vo = ProcessStartVO.newInstance((String)"xjdgl", (String)this.purOrder.getOrderNo(), (String)this.purOrder.getId(), (String)displayPage);
            vo.setListenerClass(ApprovePassListener.class);
            startProcess = invoker.getWorkFlowService().startProcess(vo);
        }
        if (startProcess == null) {
            throw new CommonException("\u542f\u52a8\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25");
        }
        return null;
    }

    private void vaild(PurOrder purOrder) {
        Assert.isNotNull((Object)purOrder, (String)"\u8be2\u4ef7\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (!InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
            throw new CommonException("\u53ea\u6709\u5df2\u53d1\u5e03\u7684\u8be2\u4ef7\u5355\u624d\u80fd\u63d0\u4ea4\u5ba1\u6279");
        }
        if (InquiryQuoteStatus.UNQUOTED.getCode().equals(purOrder.getQuoteStatus())) {
            throw new CommonException("\u8be2\u4ef7\u5355\u662f\u672a\u62a5\u4ef7\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
        }
        long quotedCount = purOrder.getItemList().stream().filter(orderItem -> InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())).count();
        if (quotedCount <= 0L) {
            throw new CommonException("\u6ca1\u6709\u5df2\u62a5\u4ef7\u7684\u884c\u9879\u76ee\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
        }
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId()).andQuotationStatusEqualTo(InquiryQuoteStatus.REQUOTE.getCode());
        List orderItemM001s = ((OrderItemM001Service)SpringContextHolder.getOneBean(OrderItemM001Service.class)).queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)orderItemM001s) && purOrder.getQuoteEndDate() != null && new Date().getTime() < purOrder.getQuoteEndDate().getTime()) {
            throw new CommonException(String.format("\u5b58\u5728\u5904\u4e8e\u91cd\u62a5\u4ef7\u4e2d\u7684\u8bb0\u5f55\uff0c\u8bf7\u7b49\u5f85\u4f9b\u5e94\u5546\u3010%s\u3011\u62a5\u4ef7\u540e\u518d\u63d0\u4ea4\u5ba1\u6279", ((OrderItemM001)orderItemM001s.get(0)).getSupCompanyName()));
        }
        List<IOrderItem> orderItems = purOrder.getItemList();
        orderItems.forEach(orderItem -> {
            if ((InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) && !OperationTypeEnum.isPricingOperation(orderItem.getOperation())) {
                throw new CommonException(String.format("\u8fd8\u6ca1\u6709\u786e\u5b9a\u201c\u63a5\u53d7\u201d\u6216\u201c\u62d2\u7edd\u201d\u64cd\u4f5c\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5 [%s] \u7684\u7269\u6599\u7f16\u7801 [%s],", orderItem.getSupCompanyName(), orderItem.getMaterialCode()));
            }
            if (OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation()) && StringUtils.isBlank((String)orderItem.getMaterialCode())) {
                throw new CommonException(String.format("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279\u3002\u8bf7\u68c0\u67e5\u7269\u6599\u7f16\u7801[%s]", orderItem.getMaterialCode()));
            }
        });
    }

    private void transformSupOrderToFrozen(PurOrder purOrder) {
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        InquirySupOrder tmp = new InquirySupOrder();
        tmp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
        tmp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(tmp, example);
    }

    private void validOrderItem(OrderItemM001 data) {
        Assert.isNotBlank((String)data.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getPurchaseApply(), (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getProject(), (String)"\u884c\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InquiryBusiConditionExample example2 = new InquiryBusiConditionExample();
        example2.createCriteria().andSupOrderIdEqualTo(data.getSupOrderId());
        List busiConditions = this.invoker.getInquiryBusiConditionService().queryAllObjByExample((IExample)example2);
        if (busiConditions == null || busiConditions.size() != 1) {
            throw new CommonException(String.format("\u67e5\u8be2\u4f9b\u5e94\u5546\u3010%s\u3011\u5546\u52a1\u6761\u4ef6\u6570\u636e\u5931\u8d25", data.getSupCompanyName()));
        }
        InquiryBusiCondition busiCondition = (InquiryBusiCondition)busiConditions.get(0);
        Assert.isNotBlank((String)data.getInfoCategory(), (String)"\u4fe1\u606f\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getUntaxedUnitPrice(), (String)"\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getPlanDeliveryDate(), (String)"\u8ba1\u5212\u4ea4\u8d27\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)data.getPurchaseGroup(), (String)"\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getPurOrderQuantity(), (String)"\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getMinOrderQuantity(), (String)"\u6700\u5c0f\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)busiCondition.getTaxCode(), (String)"\u7a0e\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)busiCondition.getCurrency(), (String)"\u8d27\u5e01\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getPriceUnit(), (String)"\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getValidDateFrom(), (String)"\u6709\u6548\u671f\u4ece\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)data.getValidDateTo(), (String)"\u6709\u6548\u671f\u5230\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

