/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.web.vo.ReQuoteVo;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class BatchReQuoteCommand
extends AbstractInquiryCommand<String> {
    private ReQuoteVo vo;

    public BatchReQuoteCommand(ReQuoteVo vo) {
        this.vo = vo;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotNull((Object)this.vo);
        Assert.isNotEmpty(this.vo.getIds(), (String)"\u8be2\u4ef7\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.vo.getPurOrderId(), (String)"\u8be2\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)invoker.getPurOrderService().queryObjById(this.vo.getPurOrderId());
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        List<IOrderItem> orderItemList = this.vo.getIds().parallelStream().distinct().map(orderItemId -> (IOrderItem)templateConf.getOrderItemService().queryObjById(orderItemId)).collect(Collectors.toList());
        orderItemList.forEach(orderItem -> this.valid((IOrderItem)orderItem));
        orderItemList.stream().forEach(orderItem -> this.reset((IOrderItem)orderItem, templateConf));
        List supOrderIdList = orderItemList.stream().map(IOrderItem::getSupOrderId).distinct().collect(Collectors.toList());
        InquirySupOrderExample supOrderExample = new InquirySupOrderExample();
        supOrderExample.createCriteria().andIdIn(supOrderIdList);
        InquirySupOrder temp = new InquirySupOrder();
        temp.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(temp, supOrderExample);
        PurOrder tempPurOrder = new PurOrder();
        tempPurOrder.setId(this.vo.getPurOrderId());
        tempPurOrder.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getPurOrderService().modifyObj(tempPurOrder);
        supOrderIdList.parallelStream().forEach(supordrId -> {
            InquirySupOrder supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(supordrId);
            this.sendMsg((String)supordrId, supOrder.getOrderNo(), supOrder.getSupUserId());
        });
        return null;
    }

    private void reset(IOrderItem orderItem, TemplateConf templateConf) {
        try {
            IOrderItem temp = templateConf.getOrderItemClass().newInstance();
            temp.setId(orderItem.getId());
            temp.setQuotationStatus(InquiryQuoteStatus.REQUOTE.getCode());
            temp.setOperation(OperationTypeEnum.NO_OPERATION.getCode());
            temp.setUntaxedUnitPrice(BigDecimal.ZERO);
            templateConf.getOrderItemService().modifyStatus(temp);
            if (!InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(orderItem.getQuoteType())) {
                return;
            }
            InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
            example.createCriteria().andItemIdEqualTo(orderItem.getId()).andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
            InquiryQuoteLadder tempLadder = new InquiryQuoteLadder();
            tempLadder.setUntaxedUnitPrice(BigDecimal.ZERO);
            this.invoker.getInquiryQuoteLadderService().modifyByExample(tempLadder, example);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMsg(String supOrderId, String orderNo, String supUserId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("inquirySupOrderId", supOrderId);
        data.put("orderNo", orderNo);
        Message msg = Message.init(data).setCompanyCode(this.getPurCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_REQUOTE.getCode()).setSenderId(this.getPurUser().getId()).addReceiverId(supUserId).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private void valid(IOrderItem orderItem) {
        if (!this.vo.getPurOrderId().equals(orderItem.getPurOrderId())) {
            throw new CommonException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u91cd\u62a5\u4ef7\u7684\u8be2\u4ef7\u5355\u8fdb\u884c\u91cd\u62a5\u4ef7");
        }
        if (!InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) && !InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u5df2\u62a5\u4ef7\u6216\u5df2\u91cd\u62a5\u72b6\u6001\u4e0b\u7684\u884c\u624d\u80fd\u6267\u884c\u91cd\u62a5\u4ef7\u64cd\u4f5c");
        }
    }
}

