/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ViewDetailCommand
extends AbstractInquiryCommand<PurOrder> {
    private String purOrderId;
    private TemplateConf templateConf;

    public ViewDetailCommand(String purOrderId) {
        Assert.isNotBlank((String)purOrderId, (String)"\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.purOrderId = purOrderId;
    }

    @Override
    public PurOrder execute(InquiryCommandInvoker invoker) {
        PurOrder order = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(order.getTemplateId());
        order.setTemplateConf(this.templateConf);
        order.setTargetList(this.getTargetList(this.purOrderId));
        order.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(this.purOrderId));
        order.setInquirySuppliers(invoker.getInquirySupplierService().queryByPurOrderId(this.purOrderId));
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldEnable())) {
            order.setMouldList(this.getMouldList(this.purOrderId));
        }
        order.setItemList(this.getItemList(this.purOrderId));
        if (InquiryQuoteStatus.QUOTED.getCode().equals(order.getQuoteStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(order.getQuoteStatus())) {
            order.setSupFileList(this.getSupFilesByPurOrderId(this.purOrderId));
        }
        order.setBusiConditions(this.getBusiConditionsByPupOrderId(this.purOrderId));
        return order;
    }

    private List<InquirySupFile> getSupFilesByPurOrderId(String purOrderId2) {
        InquirySupFileExample example = new InquirySupFileExample();
        example.createCriteria().andPurOrderIdEqualTo(this.purOrderId);
        List fileList = this.invoker.getInquirySupFileService().queryAllObjByExample((IExample)example);
        return fileList;
    }

    private List<ITarget> getTargetList(String purOrderId) {
        List<ITarget> targetList = this.templateConf.getTargetService().queryByPurOrderId(purOrderId);
        targetList.parallelStream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).forEach(target -> {
            List<InquiryQuoteLadder> ladderPrice = this.invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
            target.setInquiryQuoteLadders(ladderPrice);
        });
        return targetList;
    }

    private List<IOrderItem> getItemList(String purOrderId) {
        List<IOrderItem> itemList = this.templateConf.getOrderItemService().queryPublishedItemByPurOrderId(purOrderId);
        if (CollectionUtils.isEmpty(itemList)) {
            return null;
        }
        itemList.parallelStream().forEach(item -> {
            if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(item.getQuoteType())) {
                item.setInquiryQuoteLadders(this.invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
            }
        });
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable()) && CollectionUtils.isNotEmpty(itemList)) {
            this.setOrderDetail(itemList);
        }
        return itemList;
    }

    private List<IMould> getMouldList(String purOrderId) {
        List<IMould> mouldList = this.templateConf.getMouldService().queryByPurOrderId(purOrderId);
        if (Constant.YES_INT.equals(this.templateConf.getIsMouldDetailEnable())) {
            this.setMouldDetail(mouldList);
        }
        return mouldList;
    }

    private void setMouldDetail(List<IMould> mouldList) {
        if (CollectionUtils.isEmpty(mouldList)) {
            return;
        }
        mouldList.parallelStream().forEach(mould -> {
            IMouldDetailService service = this.templateConf.getTplMouLdDetail().getMouldDetailService();
            mould.setMouldDetail(service.queryByMouldId(mould.getId()));
        });
    }

    private void setOrderDetail(List<IOrderItem> itemList) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.parallelStream().forEach(item -> {
            IOrderItemDetailService orderItemService = this.templateConf.getTplOrderItemDetail().getOrderItemDetailService();
            item.setOrderItemDetail(orderItemService.queryObjByOrderItemId(item.getId()));
        });
    }

    private List<InquiryBusiCondition> getBusiConditionsByPupOrderId(String pupOrderId) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andPurOrderIdEqualTo(pupOrderId);
        List busiList = this.invoker.getInquiryBusiConditionService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            return null;
        }
        return busiList;
    }
}

