/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class DeleteMouldDetailTplCmd
extends AbstractInquiryCommand<String> {
    private List<String> idList;

    public DeleteMouldDetailTplCmd(List<String> idList) {
        this.idList = idList;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.idList, (String)"\u6a21\u677f\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.idList.stream().forEach(tplMouldDetailId -> {
            boolean isContain = invoker.getPropertyValueService().isContainTpl((String)tplMouldDetailId, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
            if (isContain) {
                throw new CommonException("\u8be5\u6a21\u677f\u5df2\u7ecf\u751f\u6210\u4e1a\u52a1\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664");
            }
        });
        boolean isConfInTemplateConf = this.idList.parallelStream().flatMap(tplMouldDetailId -> {
            TplMouldDetail tplMouldDetail = (TplMouldDetail)invoker.getTplMouLdDetailService().queryObjById(tplMouldDetailId);
            TplMouldDetailExample example = new TplMouldDetailExample();
            example.createCriteria().andCodeEqualTo(tplMouldDetail.getCode());
            List tplMouldDetailList = invoker.getTplMouLdDetailService().queryAllObjByExample((IExample)example);
            return tplMouldDetailList.stream();
        }).anyMatch(tplMoulDetail -> {
            TemplateConfExample templateConfExample = new TemplateConfExample();
            templateConfExample.createCriteria().andMouldItemDtlTplIdEqualTo(tplMoulDetail.getId());
            List tplList = invoker.getTemplateConfService().queryAllObjByExample((IExample)templateConfExample);
            return CollectionUtils.isNotEmpty((Collection)tplList);
        });
        if (isConfInTemplateConf) {
            throw new CommonException("\u8be5\u6a21\u677f\u5df2\u7ecf\u5728\u8be2\u62a5\u4ef7\u6a21\u677f\u4e2d\u914d\u7f6e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.idList.forEach(templateId -> {
            invoker.getPropertyDefService().removeAllByTpl((String)templateId, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
            invoker.getTplMouLdDetailService().deleteObjById(templateId);
        });
        return null;
    }
}

