/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.template;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateMouldDetailTplCmd;
import com.els.base.inquiry.command.template.IsTemplateConfInUsedCmd;
import com.els.base.inquiry.command.template.ModifyTemplateConfCmd;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class ModifyMouldDetailTplCmd
extends AbstractInquiryCommand<String> {
    private TplMouldDetail tplMouLdDetail;

    public ModifyMouldDetailTplCmd(TplMouldDetail tplMouLdDetail) {
        this.tplMouLdDetail = tplMouLdDetail;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank((String)this.tplMouLdDetail.getId(), (String)"\u6a21\u677fId\u4e0d\u80fd\u4e3a\u7a7a");
        if (!this.isDeleteable(this.tplMouLdDetail)) {
            invoker.getPropertyDefService().moveAllToHisByTpl(this.tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
            TplMouldDetail tmp = new TplMouldDetail();
            tmp.setId(this.tplMouLdDetail.getId());
            tmp.setIsHis(Constant.YES_INT);
            invoker.getTplMouLdDetailService().modifyObj(tmp);
            this.tplMouLdDetail.setId(null);
            CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(this.tplMouLdDetail);
            cmd.copyProperties(this);
            invoker.invoke(cmd);
            List<TemplateConf> templateConfList = this.queryTemplateConf(tmp.getId());
            if (CollectionUtils.isEmpty(templateConfList)) {
                return null;
            }
            for (TemplateConf templateConf : templateConfList) {
                if (Constant.YES_INT.equals(templateConf.getIsHis())) continue;
                templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(templateConf.getId());
                templateConf.setMouldItemDtlTplId(this.tplMouLdDetail.getId());
                templateConf.setTplMouLdDetail(this.tplMouLdDetail);
                ModifyTemplateConfCmd templateConfCmd = new ModifyTemplateConfCmd(templateConf);
                invoker.invoke(templateConfCmd);
            }
            return null;
        }
        invoker.getPropertyDefService().removeAllByTpl(this.tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        invoker.getTplMouLdDetailService().deleteObjById(this.tplMouLdDetail.getId());
        CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(this.tplMouLdDetail);
        cmd.copyProperties(this);
        return invoker.invoke(cmd);
    }

    private List<TemplateConf> queryTemplateConf(String mouldTplId) {
        TemplateConfExample example = new TemplateConfExample();
        example.createCriteria().andMouldItemDtlTplIdEqualTo(mouldTplId);
        List templateConfList = this.invoker.getTemplateConfService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)templateConfList)) {
            return null;
        }
        return templateConfList;
    }

    private boolean isDeleteable(TplMouldDetail tplMouLdDetail) {
        boolean isContain = this.invoker.getPropertyValueService().isContainTpl(tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
        if (isContain) {
            return false;
        }
        List<TemplateConf> templateConfList = this.queryTemplateConf(tplMouLdDetail.getId());
        if (CollectionUtils.isEmpty(templateConfList)) {
            return true;
        }
        return templateConfList.stream().noneMatch(template -> {
            IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(template.getId());
            return this.invoker.invoke(cmd);
        });
    }
}

