/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.entity;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractOrderItem;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.OrderItemJsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=OrderItemJsonDeSerialzer.class)
@ApiModel(value="\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
public class OrderItemM001
extends AbstractOrderItem {
    private List<PropertyValue> propertyValueList;
    @ApiModelProperty(hidden=true, value="\u53c2\u7167\u7269\u6599\u5bf9\u6bd4", dataType="button")
    private List<MaterielParity> materielParitys;
    @ApiModelProperty(hidden=true, name="\u6a21\u677f\u540d\u79f0")
    private String templateName;
    @ApiModelProperty(value="\u5ba1\u6279\u72b6\u6001\uff0c1\u672a\u5ba1\u6279\uff0c2\u5ba1\u6279\u4e2d\uff0c3\u5ba1\u6279\u901a\u8fc7\uff0c4\u5ba1\u6279\u9a73\u56de")
    private Integer auditStatus;
    @ApiModelProperty(hidden=true, name="\u4e3b\u952e")
    private String id;
    @ApiModelProperty(hidden=true, name="\u91c7\u8d2d\u65b9\u8868\u5934id")
    private String purOrderId;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u65b9\u8868\u5934id")
    private String supOrderId;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u53f7")
    private String orderNo;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u884c\u53f7(\u91c7\u8d2d\u65b9)")
    private Integer orderItemNo;
    @ApiModelProperty(position=6, name="\u7269\u6599\u7f16\u7801")
    private String materialCode;
    @ApiModelProperty(hidden=true, name="\u6392\u5e8f\u53f7(\u4f9b\u5e94\u5546\u884c\u53f7)")
    private Integer sortNo;
    @ApiModelProperty(position=17, name="\u4e0d\u542b\u7a0e\u5355\u4ef7")
    private BigDecimal untaxedUnitPrice;
    @ApiModelProperty(hidden=true, value="\u64cd\u4f5c(\u63a5\u53d7/\u62d2\u7edd)", dataType="button")
    private Integer operation;
    @ApiModelProperty(value="\u62a5\u4ef7\u72b6\u6001")
    private Integer quotationStatus;
    @ApiModelProperty(hidden=true, value="\u5b9a\u4ef7\u8bf4\u660e")
    private String pricingDescription;
    @ApiModelProperty(position=1, value="\u4f9b\u5e94\u5546\u7f16\u7801")
    private String supCompanySrmCode;
    @ApiModelProperty(position=2, value="\u4f9b\u5e94\u5546\u540d\u79f0")
    private String supCompanyName;
    @ApiModelProperty(position=3, value="\u7533\u8bf7\u65e5\u671f")
    private Date offerTime;
    @ApiModelProperty(position=5, value="\u62a5\u4ef7\u4eba")
    private String supUserName;
    @ApiModelProperty(value="\u65e0\u6cd5\u62a5\u4ef7", dataType="button")
    private Integer unableToQuote;
    @ApiModelProperty(hidden=true, value="\u521b\u5efa\u65f6\u95f4")
    private Date createTime;
    @ApiModelProperty(hidden=true, value="\u66f4\u65b0\u65f6\u95f4")
    private Date updateTime;
    @ApiModelProperty(hidden=true, name="\u8bb0\u5f55\u662f\u5426\u53ef\u7528(0=\u4e0d\u53ef\u7528\uff0c1=\u53ef\u7528)")
    private Integer isEnable;
    @ApiModelProperty(hidden=true, value="\u6a21\u677fID")
    private String templateId;
    @ApiModelProperty(hidden=true, value="\u5f85\u8be2\u4ef7\u7269\u6599ID")
    private String waitMaterialId;
    @ApiModelProperty(value="\u62a5\u4ef7\u65b9\u5f0f", dataType="button", position=20)
    private Integer quoteType;
    @ApiModelProperty(hidden=true, value="\u62a5\u4ef7\u4ebaid")
    private String supUserId;
    @ApiModelProperty(position=14, value="\u5b8c\u6210\u65f6\u95f4")
    private Date finishTime;
    @ApiModelProperty(hidden=true, name="\u7269\u6599\u6e05\u5355id")
    private String targetId;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u5546id")
    private String supCompanyId;
    @ApiModelProperty(position=4, value="\u4f9b\u5e94\u5546SAP\u7f16\u7801")
    private String supCompanySapCode;
    @ApiModelProperty(hidden=true)
    private Integer isOrderItemDetailEnable;
    @ApiModelProperty(hidden=true, name="\u6a21\u5177\u7f16\u7801")
    private String mouldCode;
    @ApiModelProperty(position=13, value="\u62a5\u4ef7\u65f6\u95f4")
    private Date quoteTime;
    @ApiModelProperty(position=12, value="\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(position=10, value="\u56fe\u53f7")
    private String mapNo;
    @ApiModelProperty(position=11, value="\u540d\u79f0")
    private String name;
    @ApiModelProperty(position=13, value="\u6570\u91cf")
    private Long quantity;
    @ApiModelProperty(position=14, value="\u6700\u8fd1\u4e00\u6b21\u91c7\u8d2d\u4e0d\u542b\u7a0e\u5355\u4ef7")
    private BigDecimal recentUntaxedUnitPrice;
    @ApiModelProperty(position=15, value="\u964d\u5e45%")
    private String decreasingAmplitude;
    @ApiModelProperty(position=16, value="\u542b\u7a0e\u5355\u4ef7")
    private BigDecimal taxedUnitPrice;
    @ApiModelProperty(position=18, value="\u53c2\u8003\u96f6\u90e8\u4ef6\u56fe\u53f7")
    private String referPartMapNo;
    @ApiModelProperty(position=19, value="\u53c2\u8003\u96f6\u90e8\u4ef6\u4ef7\u683c")
    private BigDecimal referPartPrice;
    @ApiModelProperty(position=7, value="\u4fe1\u606f\u7c7b\u522b", dataType="dic_group", notes="info_category")
    private String infoCategory;
    @ApiModelProperty(position=22, value="\u4ea4\u8d27\u5468\u671f")
    private Integer planDeliveryDate;
    @ApiModelProperty(position=23, value="\u91c7\u8d2d\u7ec4", dataType="dic_group", notes="purchasing_group")
    private String purchaseGroup;
    @ApiModelProperty(position=24, value="\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf")
    private BigDecimal purOrderQuantity;
    @ApiModelProperty(position=25, value="\u6700\u5c0f\u8ba2\u5355\u6570\u91cf")
    private BigDecimal minOrderQuantity;
    @ApiModelProperty(position=26, value="\u4ef7\u683c\u5355\u4f4d\uff08\u6bcf\u591a\u5c11\u4e2a\uff09")
    private Integer priceUnit;
    @ApiModelProperty(position=27, value="\u6709\u6548\u671f\u4ece")
    private Date validDateFrom;
    @ApiModelProperty(position=28, value="\u6709\u6548\u671f\u5230")
    private Date validDateTo;
    @ApiModelProperty(position=8, value="\u91c7\u8d2d\u7533\u8bf7")
    private String purchaseApply;
    @ApiModelProperty(position=9, value="\u884c\u53f7")
    private String project;
    @ApiModelProperty(position=29, value="\u4ef7\u683c\u53d8\u5316\u539f\u56e0", dataType="dic_group", notes="PRICE_CHANGE_REASONS")
    private String priceChangeCode;
    @ApiModelProperty(hidden=true, value="\u4ef7\u683c\u53d8\u5316\u539f\u56e0\u63cf\u8ff0")
    private String priceChangeReasons;
    @ApiModelProperty(position=30, value="\u5f71\u54cd\u90e8\u95e8", dataType="dic_group", notes="AFFECT_DEPARTMENT_CODE")
    private String affectDepartmentCode;
    @ApiModelProperty(hidden=true, value="\u5f71\u54cd\u90e8\u95e8\u7f16\u7801\u8868\u8ff0")
    private String affectDepartmentDesc;
    private static final long serialVersionUID = 1L;

    @Override
    public void isVaildForQuote() {
        Assert.isNotNull((Object)this.getUntaxedUnitPrice(), (String)"\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public IOrderItem build(PurOrder order, InquirySupOrder supOrder, ITarget target) {
        BeanUtils.copyProperties((Object)target, (Object)this);
        this.setId(UUIDGenerator.generateUUID());
        this.setPurOrderId(supOrder.getPurOrderId());
        this.setSupOrderId(supOrder.getId());
        this.setTemplateId(order.getTemplateId());
        this.setOrderNo(order.getOrderNo());
        this.setOrderItemNo(target.getOrderItemNo());
        this.setTargetId(target.getId());
        this.setMaterialCode(target.getMaterialCode());
        this.setQuoteType(target.getQuoteType());
        this.setSortNo(target.getSortNo());
        this.setWaitMaterialId(target.getWaitMaterialId());
        this.setMapNo(target.getMapNo());
        this.setName(target.getName());
        this.setQuantity(target.getQuantity());
        this.setRecentUntaxedUnitPrice(target.getRecentUntaxedUnitPrice());
        this.setDecreasingAmplitude(target.getDecreasingAmplitude());
        this.setPurchaseGroup(target.getPurchaseGroup());
        this.setPurOrderQuantity(target.getPurOrderQuantity());
        this.setMinOrderQuantity(target.getMinOrderQuantity());
        this.setPriceUnit(target.getPriceUnit());
        this.setValidDateFrom(target.getValidDateFrom());
        this.setValidDateTo(target.getValidDateTo());
        this.setSupCompanyId(supOrder.getSupCompanyId());
        this.setSupCompanyName(supOrder.getSupCompanyName());
        this.setSupCompanySapCode(supOrder.getSupCompanySapCode());
        this.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
        this.setCreateTime(new Date());
        this.setUnableToQuote(Constant.NO_INT);
        this.setQuotationStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        if (CollectionUtils.isEmpty(target.getPropertyValueList())) {
            return this;
        }
        List<PropertyValue> propertyValueList = target.getPropertyValueList().stream().map(propertyValue -> {
            PropertyValue temp = new PropertyValue();
            BeanUtils.copyProperties((Object)propertyValue, (Object)temp);
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
        this.setPropertyValueList(propertyValueList);
        return this;
    }

    @Override
    public List<PropertyValue> getPropertyValueList() {
        return this.propertyValueList;
    }

    @Override
    public void setPropertyValueList(List<PropertyValue> propertyValueList) {
        this.propertyValueList = propertyValueList;
    }

    @Override
    public List<PropertyDef> getPropertyDefList() {
        PurOrder purOrder;
        if (StringUtils.isNotBlank((String)this.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(this.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        if (StringUtils.isNotBlank((String)this.getPurOrderId()) && (purOrder = (PurOrder)((PurOrderService)SpringContextHolder.getOneBean(PurOrderService.class)).queryObjById(this.getPurOrderId())) != null && StringUtils.isNotBlank((String)purOrder.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(purOrder.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        return PropertyDefUtils.getProperyDefByClass(this.getClass());
    }

    public List<MaterielParity> getMaterielParitys() {
        return this.materielParitys;
    }

    public void setMaterielParitys(List<MaterielParity> materielParitys) {
        this.materielParitys = materielParitys;
    }

    @Override
    public Class<? extends IOrderItemService> getOrderItemService() {
        return OrderItemM001Service.class;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    @Override
    public String getPurOrderId() {
        return this.purOrderId;
    }

    @Override
    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    @Override
    public String getSupOrderId() {
        return this.supOrderId;
    }

    @Override
    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public Integer getOrderItemNo() {
        return this.orderItemNo;
    }

    @Override
    public void setOrderItemNo(Integer orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    @Override
    public String getMaterialCode() {
        return this.materialCode;
    }

    @Override
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    @Override
    public BigDecimal getUntaxedUnitPrice() {
        return this.untaxedUnitPrice;
    }

    @Override
    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    @Override
    public Integer getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    @Override
    public Integer getQuotationStatus() {
        return this.quotationStatus;
    }

    @Override
    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    public String getPricingDescription() {
        return this.pricingDescription;
    }

    public void setPricingDescription(String pricingDescription) {
        this.pricingDescription = pricingDescription == null ? null : pricingDescription.trim();
    }

    public String getSupCompanySrmCode() {
        return this.supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    @Override
    public String getSupCompanyName() {
        return this.supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public Date getOfferTime() {
        return this.offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    @Override
    public String getSupUserName() {
        return this.supUserName;
    }

    @Override
    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    @Override
    public Integer getUnableToQuote() {
        return this.unableToQuote;
    }

    public void setUnableToQuote(Integer unableToQuote) {
        this.unableToQuote = unableToQuote;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getWaitMaterialId() {
        return this.waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    @Override
    public Integer getQuoteType() {
        return this.quoteType;
    }

    @Override
    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }

    @Override
    public String getSupUserId() {
        return this.supUserId;
    }

    @Override
    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId == null ? null : targetId.trim();
    }

    @Override
    public String getSupCompanyId() {
        return this.supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    @Override
    public String getSupCompanySapCode() {
        return this.supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    @Override
    public Integer getIsOrderItemDetailEnable() {
        return this.isOrderItemDetailEnable;
    }

    public void setIsOrderItemDetailEnable(Integer isOrderItemDetailEnable) {
        this.isOrderItemDetailEnable = isOrderItemDetailEnable;
    }

    public String getMouldCode() {
        return this.mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    @Override
    public Date getQuoteTime() {
        return this.quoteTime;
    }

    @Override
    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getMapNo() {
        return this.mapNo;
    }

    public void setMapNo(String mapNo) {
        this.mapNo = mapNo == null ? null : mapNo.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getRecentUntaxedUnitPrice() {
        return this.recentUntaxedUnitPrice;
    }

    public void setRecentUntaxedUnitPrice(BigDecimal recentUntaxedUnitPrice) {
        this.recentUntaxedUnitPrice = recentUntaxedUnitPrice;
    }

    public String getDecreasingAmplitude() {
        return this.decreasingAmplitude;
    }

    public void setDecreasingAmplitude(String decreasingAmplitude) {
        this.decreasingAmplitude = decreasingAmplitude == null ? null : decreasingAmplitude.trim();
    }

    public BigDecimal getTaxedUnitPrice() {
        return this.taxedUnitPrice;
    }

    public void setTaxedUnitPrice(BigDecimal taxedUnitPrice) {
        this.taxedUnitPrice = taxedUnitPrice;
    }

    public String getReferPartMapNo() {
        return this.referPartMapNo;
    }

    public void setReferPartMapNo(String referPartMapNo) {
        this.referPartMapNo = referPartMapNo == null ? null : referPartMapNo.trim();
    }

    public BigDecimal getReferPartPrice() {
        return this.referPartPrice;
    }

    public void setReferPartPrice(BigDecimal referPartPrice) {
        this.referPartPrice = referPartPrice;
    }

    public String getInfoCategory() {
        return this.infoCategory;
    }

    public void setInfoCategory(String infoCategory) {
        this.infoCategory = infoCategory == null ? null : infoCategory.trim();
    }

    @Override
    public Integer getPlanDeliveryDate() {
        return this.planDeliveryDate;
    }

    public void setPlanDeliveryDate(Integer planDeliveryDate) {
        this.planDeliveryDate = planDeliveryDate;
    }

    public String getPurchaseGroup() {
        return this.purchaseGroup;
    }

    public void setPurchaseGroup(String purchaseGroup) {
        this.purchaseGroup = purchaseGroup == null ? null : purchaseGroup.trim();
    }

    public BigDecimal getPurOrderQuantity() {
        return this.purOrderQuantity;
    }

    public void setPurOrderQuantity(BigDecimal purOrderQuantity) {
        this.purOrderQuantity = purOrderQuantity;
    }

    public BigDecimal getMinOrderQuantity() {
        return this.minOrderQuantity;
    }

    public void setMinOrderQuantity(BigDecimal minOrderQuantity) {
        this.minOrderQuantity = minOrderQuantity;
    }

    public Integer getPriceUnit() {
        return this.priceUnit;
    }

    public void setPriceUnit(Integer priceUnit) {
        this.priceUnit = priceUnit;
    }

    public Date getValidDateFrom() {
        return this.validDateFrom;
    }

    public void setValidDateFrom(Date validDateFrom) {
        this.validDateFrom = validDateFrom;
    }

    public Date getValidDateTo() {
        return this.validDateTo;
    }

    public void setValidDateTo(Date validDateTo) {
        this.validDateTo = validDateTo;
    }

    public String getPurchaseApply() {
        return this.purchaseApply;
    }

    public void setPurchaseApply(String purchaseApply) {
        this.purchaseApply = purchaseApply == null ? null : purchaseApply.trim();
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project == null ? null : project.trim();
    }

    public String getPriceChangeCode() {
        return this.priceChangeCode;
    }

    public void setPriceChangeCode(String priceChangeCode) {
        this.priceChangeCode = priceChangeCode == null ? null : priceChangeCode.trim();
    }

    public String getPriceChangeReasons() {
        return this.priceChangeReasons;
    }

    public void setPriceChangeReasons(String priceChangeReasons) {
        this.priceChangeReasons = priceChangeReasons == null ? null : priceChangeReasons.trim();
    }

    public String getAffectDepartmentCode() {
        return this.affectDepartmentCode;
    }

    public void setAffectDepartmentCode(String affectDepartmentCode) {
        this.affectDepartmentCode = affectDepartmentCode == null ? null : affectDepartmentCode.trim();
    }

    public String getAffectDepartmentDesc() {
        return this.affectDepartmentDesc;
    }

    public void setAffectDepartmentDesc(String affectDepartmentDesc) {
        this.affectDepartmentDesc = affectDepartmentDesc == null ? null : affectDepartmentDesc.trim();
    }
}

