/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.InformationRecordMapper;
import com.els.base.inquiry.entity.InformationRecord;
import com.els.base.inquiry.entity.InformationRecordExample;
import com.els.base.inquiry.service.InformationRecordService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInformationRecordService")
public class InformationRecordServiceImpl
implements InformationRecordService {
    @Resource
    protected InformationRecordMapper informationRecordMapper;

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void addObj(InformationRecord t) {
        this.informationRecordMapper.insertSelective(t);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void deleteObjById(String id) {
        this.informationRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void modifyObj(InformationRecord t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.informationRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public InformationRecord queryObjById(String id) {
        return this.informationRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public List<InformationRecord> queryAllObjByExample(InformationRecordExample example) {
        return this.informationRecordMapper.selectByExample(example);
    }

    @Cacheable(value={"informationRecord"}, keyGenerator="redisKeyGenerator")
    public PageView<InformationRecord> queryObjByPage(InformationRecordExample example) {
        PageView<InformationRecord> pageView = example.getPageView();
        pageView.setQueryResult(this.informationRecordMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void addAll(List<InformationRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.informationRecordMapper.insertSelective((InformationRecord)item);
            }
        });
    }

    @CacheEvict(value={"informationRecord"}, allEntries=true)
    public void deleteByExample(InformationRecordExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.informationRecordMapper.deleteByExample(arg0);
    }
}

