/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.dao.InquiryMouldMapper;
import com.els.base.inquiry.entity.InquiryMould;
import com.els.base.inquiry.entity.InquiryMouldExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.InquiryMouldService;
import com.els.base.inquiry.utils.PropertyValueUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquiryMouldService")
public class InquiryMouldServiceImpl
implements InquiryMouldService {
    @Resource
    protected InquiryMouldMapper inquiryMouldMapper;

    @Transactional
    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void addObj(InquiryMould t) {
        this.setDefaultValue(t);
        this.inquiryMouldMapper.insertSelective(t);
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.MOULD_TYPE.getCode());
    }

    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryMouldMapper.deleteByPrimaryKey(id);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(id), PropertyDefTplType.MOULD_TYPE.getCode());
    }

    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void modifyObj(InquiryMould t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryMouldMapper.updateByPrimaryKeySelective(t);
        PropertyValueUtils.deleteByExtenable(Arrays.asList(t.getId()), PropertyDefTplType.MOULD_TYPE.getCode());
        PropertyValueUtils.addPropertyValue(Arrays.asList(t), PropertyDefTplType.MOULD_TYPE.getCode());
    }

    @Cacheable(value={"inquiryMould"}, keyGenerator="redisKeyGenerator")
    public InquiryMould queryObjById(String id) {
        InquiryMould mould = this.inquiryMouldMapper.selectByPrimaryKey(id);
        PropertyValueUtils.queryAndSetValue(Arrays.asList(mould), PropertyDefTplType.MOULD_TYPE.getCode());
        return mould;
    }

    @Cacheable(value={"inquiryMould"}, keyGenerator="redisKeyGenerator")
    public List<InquiryMould> queryAllObjByExample(InquiryMouldExample example) {
        List<InquiryMould> list = this.inquiryMouldMapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_TYPE.getCode());
        return list;
    }

    @Cacheable(value={"inquiryMould"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryMould> queryObjByPage(InquiryMouldExample example) {
        PageView<InquiryMould> pageView = example.getPageView();
        List<InquiryMould> list = this.inquiryMouldMapper.selectByExampleByPage(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_TYPE.getCode());
        pageView.setQueryResult(list);
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void deleteBySupOrder(String supOrderId) {
        Assert.isNotBlank((String)supOrderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        InquiryMouldExample example = new InquiryMouldExample();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<InquiryMould> mouldList = this.inquiryMouldMapper.selectByExample(example);
        List<String> mouldIdList = mouldList.stream().map(InquiryMould::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(mouldIdList, PropertyDefTplType.MOULD_TYPE.getCode());
        this.inquiryMouldMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void deleteByPurOrder(String purOrderId) {
        Assert.isNotBlank((String)purOrderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        InquiryMouldExample example = new InquiryMouldExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<InquiryMould> mouldList = this.inquiryMouldMapper.selectByExample(example);
        List<String> mouldIdList = mouldList.stream().map(InquiryMould::getId).collect(Collectors.toList());
        PropertyValueUtils.deleteByExtenable(mouldIdList, PropertyDefTplType.MOULD_TYPE.getCode());
        this.inquiryMouldMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void addAll(List<InquiryMould> mouldList) {
        if (CollectionUtils.isEmpty(mouldList)) {
            return;
        }
        mouldList.stream().forEach(mould -> this.setDefaultValue((InquiryMould)mould));
        this.inquiryMouldMapper.insertBatch(mouldList);
        PropertyValueUtils.addPropertyValue(mouldList, PropertyDefTplType.MOULD_TYPE.getCode());
    }

    private void setDefaultValue(InquiryMould newMould) {
        if (StringUtils.isBlank((String)newMould.getId())) {
            newMould.setId(UUIDGenerator.generateUUID());
        }
        if (newMould.getCreateTime() == null) {
            newMould.setCreateTime(new Date());
        }
        if (!Constant.YES_INT.equals(newMould.getIsEnable()) && !Constant.NO_INT.equals(newMould.getIsEnable())) {
            newMould.setIsEnable(Constant.YES_INT);
        }
    }

    @Override
    @Cacheable(value={"inquiryMould"}, keyGenerator="redisKeyGenerator")
    public List<? extends IMould> queryBySupOrderId(String supOrderId) {
        InquiryMouldExample example = new InquiryMouldExample();
        example.createCriteria().andSupOrderIdEqualTo(supOrderId);
        List<InquiryMould> list = this.inquiryMouldMapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_TYPE.getCode());
        return list;
    }

    @Override
    @Cacheable(value={"inquiryMould"}, keyGenerator="redisKeyGenerator")
    public List<? extends IMould> queryByPurOrderId(String purOrderId) {
        InquiryMouldExample example = new InquiryMouldExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        List<InquiryMould> list = this.inquiryMouldMapper.selectByExample(example);
        PropertyValueUtils.queryAndSetValue(list, PropertyDefTplType.MOULD_TYPE.getCode());
        return list;
    }

    @CacheEvict(value={"inquiryMould"}, allEntries=true)
    public void deleteByExample(InquiryMouldExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.inquiryMouldMapper.deleteByExample(arg0);
    }
}

