/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquiryPurFileMapper;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquiryPurFileExample;
import com.els.base.inquiry.service.InquiryPurFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquiryPurFileService")
public class InquiryPurFileServiceImpl
implements InquiryPurFileService {
    @Resource
    protected InquiryPurFileMapper inquiryPurFileMapper;

    @CacheEvict(value={"inquiryPurFile"}, allEntries=true)
    public void addObj(InquiryPurFile t) {
        this.inquiryPurFileMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquiryPurFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryPurFileMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"inquiryPurFile"}, allEntries=true)
    public void deleteByExample(InquiryPurFileExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.inquiryPurFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"inquiryPurFile"}, allEntries=true)
    public void modifyObj(InquiryPurFile t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryPurFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquiryPurFile"}, keyGenerator="redisKeyGenerator")
    public InquiryPurFile queryObjById(String id) {
        return this.inquiryPurFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquiryPurFile"}, keyGenerator="redisKeyGenerator")
    public List<InquiryPurFile> queryAllObjByExample(InquiryPurFileExample example) {
        return this.inquiryPurFileMapper.selectByExample(example);
    }

    @Cacheable(value={"inquiryPurFile"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryPurFile> queryObjByPage(InquiryPurFileExample example) {
        PageView<InquiryPurFile> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryPurFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"inquiryPurFile"}, keyGenerator="redisKeyGenerator")
    public List<InquiryPurFile> queryByPurOrderId(String purOrderId) {
        InquiryPurFileExample example = new InquiryPurFileExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrderId);
        return this.queryAllObjByExample(example);
    }

    @Transactional
    @CacheEvict(value={"inquiryPurFile"}, allEntries=true)
    public void addAll(List<InquiryPurFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.inquiryPurFileMapper.insertSelective((InquiryPurFile)item);
            }
        });
    }
}

