/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquiryQuoteLadderMapper;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryQuoteLadderExample;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultInquiryQuoteLadderService")
public class InquiryQuoteLadderServiceImpl
implements InquiryQuoteLadderService {
    @Resource
    protected InquiryQuoteLadderMapper inquiryQuoteLadderMapper;

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void addObj(InquiryQuoteLadder t) {
        this.inquiryQuoteLadderMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquiryQuoteLadderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void modifyObj(InquiryQuoteLadder t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquiryQuoteLadderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public InquiryQuoteLadder queryObjById(String id) {
        return this.inquiryQuoteLadderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public List<InquiryQuoteLadder> queryAllObjByExample(InquiryQuoteLadderExample example) {
        return this.inquiryQuoteLadderMapper.selectByExample(example);
    }

    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public PageView<InquiryQuoteLadder> queryObjByPage(InquiryQuoteLadderExample example) {
        PageView<InquiryQuoteLadder> pageView = example.getPageView();
        pageView.setQueryResult(this.inquiryQuoteLadderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void deleteByExample(InquiryQuoteLadderExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.inquiryQuoteLadderMapper.deleteByExample(example);
    }

    @Override
    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public BigDecimal queryLowestPriceForItem(String itemId) {
        InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
        example.createCriteria().andItemIdEqualTo(itemId);
        example.setOrderByClause("UNTAXED_UNIT_PRICE ASC");
        List<InquiryQuoteLadder> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return BigDecimal.ZERO;
        }
        return list.get(0).getUntaxedUnitPrice();
    }

    @Override
    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void addAll(List<InquiryQuoteLadder> inquiryQuoteLadderList) {
        if (CollectionUtils.isEmpty(inquiryQuoteLadderList)) {
            return;
        }
        inquiryQuoteLadderList.forEach(ladderPrice -> {
            if (StringUtils.isBlank((String)ladderPrice.getId())) {
                ladderPrice.setId(UUIDGenerator.generateUUID());
            }
        });
        this.inquiryQuoteLadderMapper.insertBatch(inquiryQuoteLadderList);
    }

    @Override
    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public List<InquiryQuoteLadder> queryByTargetId(String targetId) {
        InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
        example.createCriteria().andBelongTypeEqualTo(InquiryLadderBelongType.BELONG_TO_TARGET.getCode()).andTargetIdEqualTo(targetId);
        return this.inquiryQuoteLadderMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"inquiryQuoteLadder"}, keyGenerator="redisKeyGenerator")
    public List<InquiryQuoteLadder> queryByOrderItemId(String itemId) {
        InquiryQuoteLadderExample example = new InquiryQuoteLadderExample();
        example.setOrderByClause("NUMBER_FROM ASC");
        example.createCriteria().andItemIdEqualTo(itemId);
        return this.inquiryQuoteLadderMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"inquiryQuoteLadder"}, allEntries=true)
    public void modifyByExample(InquiryQuoteLadder t, InquiryQuoteLadderExample example) {
        this.inquiryQuoteLadderMapper.updateByExampleSelective(t, example);
    }
}

