/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.inquiry.dao.InquirySupplierMapper;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.InquirySupplierExample;
import com.els.base.inquiry.service.InquirySupplierService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInquirySupplierService")
public class InquirySupplierServiceImpl
implements InquirySupplierService {
    @Resource
    protected InquirySupplierMapper inquirySupplierMapper;

    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void addObj(InquirySupplier t) {
        this.inquirySupplierMapper.insertSelective(t);
    }

    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void deleteObjById(String id) {
        this.inquirySupplierMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void modifyObj(InquirySupplier t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.inquirySupplierMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"inquirySupplier"}, keyGenerator="redisKeyGenerator")
    public InquirySupplier queryObjById(String id) {
        return this.inquirySupplierMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"inquirySupplier"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupplier> queryAllObjByExample(InquirySupplierExample example) {
        return this.inquirySupplierMapper.selectByExample(example);
    }

    @Cacheable(value={"inquirySupplier"}, keyGenerator="redisKeyGenerator")
    public PageView<InquirySupplier> queryObjByPage(InquirySupplierExample example) {
        PageView<InquirySupplier> pageView = example.getPageView();
        pageView.setQueryResult(this.inquirySupplierMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"inquirySupplier"}, keyGenerator="redisKeyGenerator")
    public List<InquirySupplier> queryByPurOrderId(String purOrderId) {
        List<InquirySupplier> inquirySuppliers = null;
        if (StringUtils.isNotBlank((String)purOrderId)) {
            InquirySupplierExample example = new InquirySupplierExample();
            example.createCriteria().andPurOrderIdEqualTo(purOrderId);
            inquirySuppliers = this.inquirySupplierMapper.selectByExampleByPage(example);
        }
        return inquirySuppliers;
    }

    @Override
    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void addAll(String purOrderId, List<InquirySupplier> inquirySuppliers) {
        if (CollectionUtils.isEmpty(inquirySuppliers)) {
            return;
        }
        for (InquirySupplier inquirySupplier : inquirySuppliers) {
            inquirySupplier.setPurOrderId(purOrderId);
            this.inquirySupplierMapper.insertSelective(inquirySupplier);
        }
    }

    @Override
    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void deleteByExample(InquirySupplierExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.inquirySupplierMapper.deleteByExample(example);
    }

    @Transactional
    @CacheEvict(value={"inquirySupplier"}, allEntries=true)
    public void addAll(List<InquirySupplier> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.inquirySupplierMapper.insertSelective((InquirySupplier)item);
            }
        });
    }
}

