/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.PropertyValueMapper;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PropertyValueExample;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultPropertyValueService")
public class PropertyValueServiceImpl
implements PropertyValueService {
    @Resource
    protected PropertyValueMapper propertyValueMapper;

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    public void addObj(PropertyValue t) {
        Assert.isNotBlank((String)t.getCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)t.getType(), (String)"\u5b57\u6bb5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        this.propertyValueMapper.insertSelective(t);
    }

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    public void deleteObjById(String id) {
        this.propertyValueMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"propertyValue"}, allEntries=true)
    public void modifyObj(PropertyValue t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.propertyValueMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"propertyValue"}, keyGenerator="redisKeyGenerator")
    public PropertyValue queryObjById(String id) {
        return this.propertyValueMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"propertyValue"}, keyGenerator="redisKeyGenerator")
    public List<PropertyValue> queryAllObjByExample(PropertyValueExample example) {
        return this.propertyValueMapper.selectByExample(example);
    }

    @Cacheable(value={"propertyValue"}, keyGenerator="redisKeyGenerator")
    public PageView<PropertyValue> queryObjByPage(PropertyValueExample example) {
        PageView<PropertyValue> pageView = example.getPageView();
        pageView.setQueryResult(this.propertyValueMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"propertyValue"}, keyGenerator="redisKeyGenerator")
    public boolean isContainTpl(String tplId, String propertyDefTplTypeCode) {
        PropertyValueExample example = new PropertyValueExample();
        example.createCriteria().andTplIdEqualTo(tplId).andTplTypeEqualTo(propertyDefTplTypeCode);
        return this.propertyValueMapper.countByExample(example) > 0;
    }

    @Override
    @CacheEvict(value={"propertyValue"}, allEntries=true)
    public void addAll(List<PropertyValue> propertyValueList) {
        if (CollectionUtils.isEmpty(propertyValueList)) {
            return;
        }
        propertyValueList.forEach(propertyValue -> {
            if (StringUtils.isBlank((String)propertyValue.getId())) {
                propertyValue.setId(UUIDGenerator.generateUUID());
            }
        });
        this.propertyValueMapper.insertBatch(propertyValueList);
    }

    @Override
    @CacheEvict(value={"propertyValue"}, allEntries=true)
    public void deleteByExample(PropertyValueExample propertyValueExample) {
        this.propertyValueMapper.deleteByExample(propertyValueExample);
    }
}

