/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.dao.SystemPriceMapper;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.SystemPriceExample;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSystemPriceService")
public class SystemPriceServiceImpl
implements SystemPriceService {
    @Resource
    protected SystemPriceMapper systemPriceMapper;

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    public void addObj(SystemPrice t) {
        Assert.isNotNull((Object)t, (String)"\u8981\u4fdd\u5b58\u7684\u53c2\u6570\u4e3a\u7a7a");
        this.systemPriceMapper.insertSelective(t);
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    public void deleteObjById(String id) {
        this.systemPriceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    public void modifyObj(SystemPrice t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.systemPriceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"systemPrice"}, keyGenerator="redisKeyGenerator")
    public SystemPrice queryObjById(String id) {
        return this.systemPriceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"systemPrice"}, keyGenerator="redisKeyGenerator")
    public List<SystemPrice> queryAllObjByExample(SystemPriceExample example) {
        return this.systemPriceMapper.selectByExample(example);
    }

    @Cacheable(value={"systemPrice"}, keyGenerator="redisKeyGenerator")
    public PageView<SystemPrice> queryObjByPage(SystemPriceExample example) {
        PageView<SystemPrice> pageView = example.getPageView();
        pageView.setQueryResult(this.systemPriceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"systemPrice"}, keyGenerator="redisKeyGenerator")
    public SystemPrice queryByMaterialAndSupCompany(String materialCode, String companySapCode) {
        if (StringUtils.isBlank((String)materialCode) || StringUtils.isBlank((String)companySapCode)) {
            return null;
        }
        SystemPriceExample example = new SystemPriceExample();
        example.createCriteria().andMaterialCodeEqualTo(materialCode).andCompanySapCodeEqualTo(companySapCode);
        example.setOrderByClause("CREATE_TIME DESC");
        List<SystemPrice> list = this.systemPriceMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Transactional
    @CacheEvict(value={"systemPrice"}, allEntries=true)
    public void addAll(List<SystemPrice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.systemPriceMapper.insertSelective((SystemPrice)item);
            }
        });
    }

    @CacheEvict(value={"systemPrice"}, allEntries=true)
    public void deleteByExample(SystemPriceExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.systemPriceMapper.deleteByExample(arg0);
    }
}

