/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.excel;

import com.els.base.core.exception.CommonException;
import com.els.base.utils.excel.TitleAndModelKey;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import org.apache.commons.collections.CollectionUtils;

public class ExcelUtil {
    public static List<Map<String, String>> importExcelDataToMap(InputStream in, int sheetIndex, int dataStartRowIndex, int headRowIndex, List<TitleAndModelKey> titleAndModelKeys) throws Exception {
        if (CollectionUtils.isEmpty(titleAndModelKeys)) {
            throw new NullPointerException("export setting 'titleAndModelKeys' can not be null");
        }
        Workbook workbook = Workbook.getWorkbook((InputStream)in);
        Sheet sheet = workbook.getSheet(sheetIndex);
        List<Map<String, String>> results = ExcelUtil.getAllRows(sheet, dataStartRowIndex, titleAndModelKeys);
        return results;
    }

    private static List<Map<String, String>> getAllRows(Sheet sheet, int dataStartRowIndex, List<TitleAndModelKey> titleAndModelKeys) {
        int rowNum = sheet.getRows();
        if (dataStartRowIndex >= rowNum) {
            throw new CommonException("\u60a8\u6ca1\u6709\u586b\u5199\u884c\u6570\u636e");
        }
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(rowNum);
        int columnNum = titleAndModelKeys.size();
        for (int readIndex = dataStartRowIndex; readIndex < rowNum; ++readIndex) {
            HashMap<String, String> map = new HashMap<String, String>(columnNum);
            for (int i = 0; i < columnNum; ++i) {
                Cell cell = sheet.getCell(i, readIndex);
                map.put(titleAndModelKeys.get(i).getModelKey(), cell.getContents());
            }
            results.add(map);
        }
        return results;
    }
}

