/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.excel;

import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TargetM001;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.excel.ExcelUtil;
import com.els.base.material.dao.MaterialMapper;
import com.els.base.material.entity.MaterialExample;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;

public class OrderItemExcelUtils {
    private static final String purchaseGroupCode = "purchasing_group";
    private static final String infoCategoryCode = "info_category";
    private static final String[] parsePatterns = new String[]{"yyyyMMdd"};
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(String templateId, ServletOutputStream os) throws RowsExceededException, WriteException, IOException, ParseException {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(templateId);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        List<PropertyDef> propertyDefList = templateConf.getOrderItemPropertyDefList();
        Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = OrderItemExcelUtils.transfromProDef(propertyDefList);
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, null, (String)"\u5bfc\u5165\u7269\u6599", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
    }

    private static List<TitleAndModelKey> transfromProDef(List<PropertyDef> propertyDefList) {
        Assert.isNotEmpty(propertyDefList, (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801[\u5fc5\u586b]", (String)"materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4fe1\u606f\u7c7b\u522b[\u5fc5\u586b]", (String)"infoCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7[\u5fc5\u586b]", (String)"purchaseApply"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u9879\u76ee\u53f7[\u5fc5\u586b]", (String)"project"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7[\u5fc5\u586b]", (String)"mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u540d\u79f0[\u5fc5\u586b]", (String)"name"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf[\u5fc5\u586b]", (String)"quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u8fd1\u4e00\u6b21\u91c7\u8d2d\u4e0d\u542b\u7a0e\u5355\u4ef7[\u5fc5\u586b]", (String)"recentUntaxedUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u964d\u5e45[\u5fc5\u586b]", (String)"decreasingAmplitude"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62a5\u4ef7\u65b9\u5f0f\uff0c\u586b1\u5e38\u89c4\u62a5\u4ef7\uff0c\u586b2\u9636\u68af\u62a5\u4ef7[\u5fc5\u586b]", (String)"quoteType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7ec4[\u5fc5\u586b]", (String)"purchaseGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf", (String)"purOrderQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u5c0f\u8ba2\u5355\u6570\u91cf", (String)"minOrderQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d[\u5fc5\u586b]", (String)"priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6709\u6548\u671f\u4ece(yyyyMMdd)[\u5fc5\u586b]", (String)"validDateFrom"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6709\u6548\u671f\u5230(yyyyMMdd)[\u5fc5\u586b]", (String)"validDateTo"));
        return titleAndModelKeys;
    }

    public static List<? extends ITarget> importFromExcel(String templateId, InputStream in) throws Exception {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(templateId);
        Assert.isNotNull((Object)templateConf, (String)"\u6a21\u677f\u4e0d\u80fd\u4e3a\u7a7a");
        List<PropertyDef> propertyDefList = templateConf.getOrderItemPropertyDefList();
        Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), (String)"\u6a21\u677f\u7684\u5b57\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
        List<TitleAndModelKey> titleAndModelKeys = OrderItemExcelUtils.transfromProDef(propertyDefList);
        List<Map<String, String>> results = ExcelUtil.importExcelDataToMap(in, 0, 1, 0, titleAndModelKeys);
        List<? extends ITarget> targetList = OrderItemExcelUtils.convertMapListToTargetList(results, templateId);
        return targetList;
    }

    private static List<? extends ITarget> convertMapListToTargetList(List<Map<String, String>> results, String templateId) {
        if (CollectionUtils.isEmpty(results)) {
            return null;
        }
        ArrayList<TargetM001> targetM001s = new ArrayList<TargetM001>();
        List<String> validCodes = Arrays.asList(infoCategoryCode, purchaseGroupCode);
        DicGroupExample example = new DicGroupExample();
        example.createCriteria().andCodeIn(validCodes);
        List dicGroups = ((DicGroupService)SpringContextHolder.getOneBean(DicGroupService.class)).queryAllObjByExample(example);
        if (CollectionUtils.isEmpty((Collection)dicGroups) || dicGroups.size() != validCodes.size()) {
            throw new CommonException("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        HashMap<String, String> dicGroupMap = new HashMap<String, String>(dicGroups.size());
        for (DicGroup dicGroup : dicGroups) {
            dicGroupMap.put(dicGroup.getCode(), dicGroup.getId());
        }
        DicGroupItemExample itemExample = new DicGroupItemExample();
        itemExample.createCriteria().andGroupIdEqualTo((String)dicGroupMap.get(infoCategoryCode));
        List infoCategoryCodes = ((DicGroupItemService)SpringContextHolder.getOneBean(DicGroupItemService.class)).queryAllObjByExample(itemExample);
        Assert.isNotEmpty((Collection)infoCategoryCodes, (String)"\u672a\u627e\u5230\u4fe1\u606f\u7c7b\u522b\u7684\u6570\u636e\u5b57\u5178");
        Set<String> infoCategoryCodeSet = infoCategoryCodes.stream().map(DicGroupItem::getValue).collect(Collectors.toSet());
        itemExample.clear();
        itemExample.createCriteria().andGroupIdEqualTo((String)dicGroupMap.get(purchaseGroupCode));
        List purchaseGroupCodes = ((DicGroupItemService)SpringContextHolder.getOneBean(DicGroupItemService.class)).queryAllObjByExample(itemExample);
        Assert.isNotEmpty((Collection)purchaseGroupCodes, (String)"\u672a\u627e\u5230\u91c7\u8d2d\u7ec4\u7684\u6570\u636e\u5b57\u5178");
        Set<String> purchaseGroupCodeSet = purchaseGroupCodes.stream().map(DicGroupItem::getValue).collect(Collectors.toSet());
        int i = 2;
        for (Map<String, String> result : results) {
            OrderItemExcelUtils.valid(result, i, infoCategoryCodeSet, purchaseGroupCodeSet);
            TargetM001 targetM001 = OrderItemExcelUtils.convertMapToTarget(result, templateId);
            targetM001s.add(targetM001);
            ++i;
        }
        return targetM001s;
    }

    private static TargetM001 convertMapToTarget(Map<String, String> result, String templateId) {
        TargetM001 targetM001 = new TargetM001();
        targetM001.setTemplateId(templateId);
        targetM001.setMaterialCode(result.get("materialCode"));
        targetM001.setInfoCategory(result.get("infoCategory"));
        targetM001.setPurchaseApply(result.get("purchaseApply"));
        targetM001.setProject(result.get("project"));
        targetM001.setMapNo(result.get("mapNo"));
        targetM001.setName(result.get("name"));
        targetM001.setQuantity(Long.valueOf(result.get("quantity")));
        targetM001.setRecentUntaxedUnitPrice(new BigDecimal(result.get("recentUntaxedUnitPrice")));
        targetM001.setDecreasingAmplitude(result.get("decreasingAmplitude"));
        targetM001.setQuoteType(Integer.valueOf(result.get("quoteType")));
        targetM001.setPurchaseGroup(result.get("purchaseGroup"));
        if (StringUtils.isNotBlank((String)result.get("purOrderQuantity"))) {
            targetM001.setPurOrderQuantity(new BigDecimal(result.get("purOrderQuantity")));
        }
        if (StringUtils.isNotBlank((String)result.get("minOrderQuantity"))) {
            targetM001.setMinOrderQuantity(new BigDecimal(result.get("minOrderQuantity")));
        }
        targetM001.setPriceUnit(Integer.valueOf(result.get("priceUnit")));
        try {
            targetM001.setValidDateFrom(formatter.parse(result.get("validDateFrom")));
        }
        catch (Exception e) {
            targetM001.setValidDateFrom(null);
        }
        try {
            targetM001.setValidDateTo(formatter.parse(result.get("validDateTo")));
        }
        catch (Exception e) {
            targetM001.setValidDateTo(null);
        }
        return targetM001;
    }

    private static void valid(Map<String, String> result, int i, Set<String> infoCategoryCodeSet, Set<String> purchaseGroupCodeSet) {
        Assert.isNotBlank((String)result.get("materialCode"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", i));
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(result.get("materialCode"));
        if (((MaterialMapper)SpringContextHolder.getOneBean(MaterialMapper.class)).countByExample(materialExample) == 0) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u4e8e\u7269\u6599\u4e3b\u6570\u636e\u4e2d", i));
        }
        Assert.isNotBlank((String)result.get("infoCategory"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u4fe1\u606f\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!infoCategoryCodeSet.contains(result.get("infoCategory"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u4fe1\u606f\u7c7b\u522b\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u4e2d", i));
        }
        Assert.isNotBlank((String)result.get("purchaseApply"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i));
        Assert.isNotBlank((String)result.get("project"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u884c\u9879\u76ee\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i));
        Assert.isNotBlank((String)result.get("mapNo"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u56fe\u53f7\u4e0d\u80fd\u4e3a\u7a7a", i));
        Assert.isNotBlank((String)result.get("name"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", i));
        Assert.isNotBlank((String)result.get("quantity"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!NumberUtils.isNumber((String)result.get("quantity"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e", i));
        }
        Assert.isNotBlank((String)result.get("recentUntaxedUnitPrice"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u6700\u8fd1\u4e00\u6b21\u91c7\u8d2d\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!NumberUtils.isNumber((String)result.get("recentUntaxedUnitPrice"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6700\u8fd1\u4e00\u6b21\u91c7\u8d2d\u4e0d\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u4e0d\u6b63\u786e", i));
        }
        Assert.isNotBlank((String)result.get("decreasingAmplitude"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u964d\u5e45\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!NumberUtils.isNumber((String)result.get("decreasingAmplitude"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u964d\u5e45\u683c\u5f0f\u4e0d\u6b63\u786e", i));
        }
        Assert.isNotBlank((String)result.get("quoteType"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!InquiryQuoteLadderType.CONVENTIONAL_QUOTE.getCode().equals(Integer.valueOf(result.get("quoteType"))) && !InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(Integer.valueOf(result.get("quoteType")))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u62a5\u4ef7\u65b9\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u586b1\u8868\u793a\u5e38\u89c4\u62a5\u4ef7\uff0c\u586b2\u8868\u793a\u9636\u68af\u62a5\u4ef7", i));
        }
        Assert.isNotBlank((String)result.get("purchaseGroup"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u91c7\u8d2d\u7ec4\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!purchaseGroupCodeSet.contains(result.get("purchaseGroup"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u91c7\u8d2d\u7ec4\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u5b57\u5178\u4e2d", i));
        }
        if (StringUtils.isNotBlank((String)result.get("purOrderQuantity")) && !NumberUtils.isNumber((String)result.get("purOrderQuantity"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6807\u51c6\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e", i));
        }
        if (StringUtils.isNotBlank((String)result.get("minOrderQuantity")) && !NumberUtils.isNumber((String)result.get("minOrderQuantity"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6700\u5c0f\u8ba2\u5355\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e", i));
        }
        Assert.isNotBlank((String)result.get("priceUnit"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u4ef7\u683c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", i));
        Assert.isNotBlank((String)result.get("validDateFrom"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u6709\u6548\u671f\u4ece\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!OrderItemExcelUtils.dateFormatIsValid(result.get("validDateFrom"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6709\u6548\u671f\u4ece\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4ee5\u5982\u201c20180101\u201d\u683c\u5f0f\u586b\u5199", i));
        }
        Assert.isNotBlank((String)result.get("validDateTo"), (String)String.format("\u7b2c%s\u884c\u4e2d\u7684\u6709\u6548\u671f\u5230\u4e0d\u80fd\u4e3a\u7a7a", i));
        if (!OrderItemExcelUtils.dateFormatIsValid(result.get("validDateTo"))) {
            throw new CommonException(String.format("\u7b2c%s\u884c\u4e2d\u7684\u6709\u6548\u671f\u5230\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4ee5\u5982\u201c20180101\u201d\u683c\u5f0f\u586b\u5199", i));
        }
    }

    private static boolean dateFormatIsValid(String dateStr) {
        try {
            DateUtils.parseDate((String)dateStr, (String[])parsePatterns);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

