/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.entity.InquiryMould;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InquiryMouldJsonDeSerialzer
extends ExtendableObjectJsonDeSerialzer<InquiryMould> {
    protected static final Logger logger = LoggerFactory.getLogger(InquiryMouldJsonDeSerialzer.class);
    private String mouldDetailJson = null;

    @Override
    public InquiryMould deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        InquiryMould instance = (InquiryMould)super.deserialize(p, ctxt);
        if (StringUtils.isBlank((String)this.mouldDetailJson)) {
            return instance;
        }
        logger.info(this.mouldDetailJson);
        if (StringUtils.isBlank((String)instance.getTemplateId())) {
            logger.warn("OrderItemM001.template == null \uff0c\u65e0\u6cd5\u89e3\u6790\u7269\u6599\u6210\u672c\u6e05\u5355");
            return instance;
        }
        IMouldDetail mouldDetail = null;
        try {
            mouldDetail = this.deserializeMouldDetail(this.mouldDetailJson, instance);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("\u53c2\u6570\u89e3\u6790\u5931\u8d25", e);
        }
        if (mouldDetail != null) {
            mouldDetail.setMouldId(instance.getId());
        }
        instance.setMouldDetail(mouldDetail);
        return instance;
    }

    private IMouldDetail deserializeMouldDetail(String mouldDetailJson, InquiryMould instance) throws JsonParseException, JsonMappingException, InstantiationException, IllegalAccessException, IOException {
        TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(instance.getTemplateId());
        if (!Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())) {
            return null;
        }
        Class<? extends IMouldDetail> clazz = templateConf.getTplMouLdDetail().getMouldDetailClass();
        DetailDeSerializer<? extends IMouldDetail> serializer = new DetailDeSerializer<IMouldDetail>(clazz);
        IMouldDetail mouldDetail = serializer.serializer(mouldDetailJson);
        return mouldDetail;
    }

    @Override
    protected void setPrimitFieldValue(InquiryMould t, Field field, JsonNode jsonNode) throws Exception {
        if (jsonNode == null) {
            return;
        }
        if (field.getName().equals("mouldDetail")) {
            this.mouldDetailJson = jsonNode.toString();
            return;
        }
        super.setPrimitFieldValue(t, field, jsonNode);
    }

    @Override
    public Class<InquiryMould> getInstanceClass() {
        return InquiryMould.class;
    }
}

