/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils.json;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryPurFile;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupplier;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.impl.TemplateConfServiceImpl;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.json.JsonUtils;
import com.els.base.utils.reflect.ReflectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PurOrderJsonDeserialzer
extends JsonDeserializer<PurOrder> {
    private String targetJson;
    private String itemsJson;
    private String mouldJson;
    private TemplateConf templateConf;

    public PurOrder deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        PurOrder order = new PurOrder();
        try {
            ObjectNode objectNode = (ObjectNode)p.readValueAsTree();
            Iterator fieldNamesIterator = objectNode.fieldNames();
            while (fieldNamesIterator.hasNext()) {
                String fieldName = (String)fieldNamesIterator.next();
                JsonNode value = objectNode.get(fieldName);
                if ("targetList".equals(fieldName)) {
                    this.targetJson = value.toString();
                    continue;
                }
                if ("itemList".equals(fieldName)) {
                    this.itemsJson = value.toString();
                    continue;
                }
                if ("mouldList".equals(fieldName)) {
                    this.mouldJson = value.toString();
                    continue;
                }
                if ("inquirySuppliers".equals(fieldName)) {
                    List inquirySuppliers = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquirySupplier.class});
                    order.setInquirySuppliers(inquirySuppliers);
                    continue;
                }
                if ("purFileList".equals(fieldName)) {
                    List inquiryPurFiles = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquiryPurFile.class});
                    order.setPurFileList(inquiryPurFiles);
                    continue;
                }
                if ("supFileList".equals(fieldName)) {
                    List inquirySupFiles = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquirySupFile.class});
                    order.setSupFileList(inquirySupFiles);
                    continue;
                }
                if ("busiConditions".equals(fieldName)) {
                    List busiConditions = (List)JsonUtils.convertCollection((String)value.toString(), List.class, null, (Class[])new Class[]{InquiryBusiCondition.class});
                    order.setBusiConditions(busiConditions);
                    continue;
                }
                Field field = null;
                try {
                    field = PurOrder.class.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    field = PurOrder.class.getSuperclass().getDeclaredField(fieldName);
                }
                ReflectUtils.setValue((Object)order, (String)fieldName, (Object)JsonUtils.convertValue((String)value.toString(), field.getType()));
            }
            if (StringUtils.isNotBlank((String)this.targetJson)) {
                this.setTargetFromValue(order);
            }
            if (StringUtils.isNotBlank((String)this.itemsJson)) {
                this.setItemsFromValue(order);
            }
            if (StringUtils.isNotBlank((String)this.mouldJson)) {
                this.setMouldFromValue(order);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u89e3\u6790\u8be2\u4ef7\u5355\u53c2\u6570\u5931\u8d25");
        }
        return order;
    }

    private TemplateConf geTemplateConf(PurOrder order) {
        if (this.templateConf != null) {
            return this.templateConf;
        }
        this.templateConf = ((TemplateConfServiceImpl)SpringContextHolder.getOneBean(TemplateConfServiceImpl.class)).queryObjById(order.getTemplateId());
        return this.templateConf;
    }

    private void setMouldFromValue(PurOrder order) throws JsonParseException, JsonMappingException, IOException {
        TemplateConf templateConf = this.geTemplateConf(order);
        Class<? extends IMould> clazz = templateConf.getMouldClass();
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{clazz});
        List moulds = (List)JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.mouldJson, javaType);
        order.setMouldList(moulds);
    }

    private void setTargetFromValue(PurOrder order) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JsonParseException, JsonMappingException, IOException {
        TemplateConf templateConf = this.geTemplateConf(order);
        Class<? extends ITarget> clazz = templateConf.getTargetClass();
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{clazz});
        List targets = (List)JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.targetJson, javaType);
        order.setTargetList(targets);
    }

    private void setItemsFromValue(PurOrder order) throws ClassNotFoundException, InstantiationException, IllegalAccessException, JsonParseException, JsonMappingException, IOException {
        TemplateConf templateConf = this.geTemplateConf(order);
        Class<? extends IOrderItem> clazz = templateConf.getOrderItemClass();
        JavaType javaType = JsonUtils.getObjectMapper().getTypeFactory().constructParametrizedType(List.class, null, new Class[]{clazz});
        List items = (List)JsonUtils.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(this.itemsJson, javaType);
        order.setItemList(items);
    }
}

