/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.KeyAndValueMapConverter;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
@Controller
@RequestMapping(value={"orderItemM001"})
public class OrderItemM001Controller {
    private static final Logger logger = LoggerFactory.getLogger(OrderItemM001Controller.class);
    @Resource
    protected PurOrderService purOrderService;
    @Resource
    protected OrderItemM001Service orderItemM001Service;
    @Resource
    protected InquiryBusiConditionService inquiryBusiConditionService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 OrderItemM001", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<OrderItemM001>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OrderItemM001Example example = new OrderItemM001Example();
        example.setPageView((PageView<OrderItemM001>)new PageView(pageNo, pageSize));
        OrderItemM001Example.Criteria criteria = example.createCriteria();
        criteria.andOperationEqualTo(OperationTypeEnum.ACCEPTED.getCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView<OrderItemM001> pageData = this.orderItemM001Service.queryForApprovePassOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7M001\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6570\u636e\u4e3a\u7a7a");
        FileData fileData = this.orderItemM001Service.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), ids);
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7\u884c\u660e\u7ec6\u6279\u91cf\u5bfc\u51fa")
    @RequestMapping(value={"service/downloadExcelForItem"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForItem(@RequestBody(required=false) QueryParamWapper wapper) {
        FileData fileData;
        OrderItemM001Example example = new OrderItemM001Example();
        OrderItemM001Example.Criteria criteria = example.createCriteria();
        criteria.andOperationEqualTo(OperationTypeEnum.ACCEPTED.getCode());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List<OrderItemM001> itemList = this.orderItemM001Service.queryForApprovePassOrder(example);
        Assert.isNotEmpty(itemList, (String)"\u62a5\u4ef7\u6570\u636e\u4e3a\u7a7a");
        List orderIds = itemList.stream().map(OrderItemM001::getPurOrderId).collect(Collectors.toList());
        PurOrderExample purOrderExample = new PurOrderExample();
        purOrderExample.createCriteria().andIdIn(orderIds);
        List orderList = this.purOrderService.queryAllObjByExample((IExample)purOrderExample);
        InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
        busiConditionExample.createCriteria().andPurOrderIdIn(orderIds);
        List busiConditions = this.inquiryBusiConditionService.queryAllObjByExample((IExample)busiConditionExample);
        List<Map<String, Object>> dataList = itemList.stream().map(item -> {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("item", (Serializable)item);
            PurOrder order = orderList.stream().filter(tmp -> tmp.getId().equals(item.getPurOrderId())).findAny().orElse(null);
            data.put("order", order);
            InquiryBusiCondition busiCondition = busiConditions.stream().filter(tmp -> tmp.getPurOrderId().equals(item.getPurOrderId()) && tmp.getSupOrderId().equals(item.getSupOrderId())).findAny().orElse(null);
            data.put("busi", busiCondition);
            return data;
        }).collect(Collectors.toList());
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        try {
            fileData = this.createExcelFileOutputStream(titleAndModelKeys, dataList, "\u7269\u6599\u62a5\u4ef7\u6e05\u5355.xml");
        }
        catch (IOException | ParseException | WriteException e) {
            logger.error("excel \u5bfc\u51fa\u5931\u8d25", e);
            throw new CommonException("excel\u5bfc\u51fa\u5931\u8d25");
        }
        return ResponseResult.success((Object)fileData);
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7\u884c\u660e\u7ec6\u6279\u91cf\u5bfc\u51fa")
    @RequestMapping(value={"service/downloadExcel"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcel(@RequestBody(required=true) List<String> orderIds) {
        FileData fileData;
        Assert.isNotEmpty(orderIds, (String)"\u6570\u636e\u4e3a\u7a7a");
        OrderItemM001Example example = new OrderItemM001Example();
        example.createCriteria().andPurOrderIdIn((List)orderIds);
        example.setOrderByClause("ORDER_NO ASC, SUP_COMPANY_SAP_CODE ASC, SORT_NO ASC");
        List itemList = this.orderItemM001Service.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)itemList, (String)"\u62a5\u4ef7\u6570\u636e\u4e3a\u7a7a");
        PurOrderExample purOrderExample = new PurOrderExample();
        purOrderExample.createCriteria().andIdIn((List)orderIds);
        List orderList = this.purOrderService.queryAllObjByExample((IExample)purOrderExample);
        InquiryBusiConditionExample busiConditionExample = new InquiryBusiConditionExample();
        busiConditionExample.createCriteria().andPurOrderIdIn((List)orderIds);
        List busiConditions = this.inquiryBusiConditionService.queryAllObjByExample((IExample)busiConditionExample);
        List<Map<String, Object>> dataList = itemList.stream().map(item -> {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>();
            data.put("item", (Serializable)item);
            PurOrder order = orderList.stream().filter(tmp -> tmp.getId().equals(item.getPurOrderId())).findAny().orElse(null);
            data.put("order", order);
            InquiryBusiCondition busiCondition = busiConditions.stream().filter(tmp -> tmp.getPurOrderId().equals(item.getPurOrderId()) && tmp.getSupOrderId().equals(item.getSupOrderId())).findAny().orElse(null);
            data.put("busi", busiCondition);
            return data;
        }).collect(Collectors.toList());
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeader();
        try {
            fileData = this.createExcelFileOutputStream(titleAndModelKeys, dataList, "\u7269\u6599\u62a5\u4ef7\u6e05\u5355.xml");
        }
        catch (IOException | ParseException | WriteException e) {
            logger.error("excel \u5bfc\u51fa\u5931\u8d25", e);
            throw new CommonException("excel\u5bfc\u51fa\u5931\u8d25");
        }
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeader() {
        HashMap<Integer, String> isApprovinMap = new HashMap<Integer, String>();
        isApprovinMap.put(new Integer(1), "\u672a\u5ba1\u6838");
        isApprovinMap.put(new Integer(2), "\u6b63\u5728\u5ba1\u6838");
        isApprovinMap.put(new Integer(3), "\u5df2\u5ba1\u6838");
        isApprovinMap.put(new Integer(4), "\u5df2\u9a73\u56de");
        KeyAndValueMapConverter isApprovingConverter = new KeyAndValueMapConverter(isApprovinMap);
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        String emptyField = "item.materielParitys";
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u53f7", (String)"item.orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7248\u672c\u53f7", (String)emptyField));
        TitleAndModelKey isApprovingKey = ExcelUtils.createTitleAndModelKey((String)"\u9001\u5ba1\u72b6\u6001", (String)"order.auditStatus");
        isApprovingKey.setToStrConverter((ObjToStrConverter)isApprovingConverter);
        titleAndModelKeys.add(isApprovingKey);
        TitleAndModelKey approvePassTimeKey = ExcelUtils.createTitleAndModelKey((String)"\u5ba1\u6279\u901a\u8fc7\u65f6\u95f4", (String)emptyField);
        approvePassTimeKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(approvePassTimeKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9a73\u56de\u6b21\u6570", (String)emptyField));
        TitleAndModelKey writeBackSapStatusKey = ExcelUtils.createTitleAndModelKey((String)"\u56de\u5199\u4fe1\u606f\u8bb0\u5f55\u72b6\u6001", (String)emptyField);
        titleAndModelKeys.add(writeBackSapStatusKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56de\u5199\u4fe1\u606f\u8bb0\u5f55\u5931\u8d25\u539f\u56e0", (String)emptyField));
        TitleAndModelKey writeBackRedLineStatusKey = ExcelUtils.createTitleAndModelKey((String)"\u56de\u5199\u7ea2\u7ebf\u4ef7\u683c\u72b6\u6001", (String)emptyField);
        titleAndModelKeys.add(writeBackRedLineStatusKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56de\u5199\u7ea2\u7ebf\u4ef7\u683c\u5931\u8d25\u539f\u56e0", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u7f16\u53f7", (String)"item.orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6838\u4ef7\u5355\u7528\u9014", (String)"order.materialUsed"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"order.purUserName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u4ee3\u7801", (String)"item.supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"item.supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"item.materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u56fe\u53f7", (String)"item.mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"item.name"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4fe1\u606f\u7c7b\u522b", (String)"item.infoCategory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6570\u91cf", (String)"item.quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u542b\u7a0e\u4ef7", (String)"item.taxedUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4e0d\u542b\u7a0e\u4ef7", (String)"item.untaxedUnitPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b2c\u4e00\u7248\u63d0\u4ea4\u542b\u7a0e\u4ef7", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b2c\u4e00\u7248\u63d0\u4ea4\u4e0d\u542b\u7a0e\u4ef7", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d27\u5e01", (String)"busi.currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef7\u683c\u5355\u4f4d", (String)"item.priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7801", (String)"busi.taxCode"));
        TitleAndModelKey validDateFromKey = ExcelUtils.createTitleAndModelKey((String)"\u6709\u6548\u671f\u4ece", (String)"item.validDateFrom");
        validDateFromKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(validDateFromKey);
        TitleAndModelKey validDateToKey = ExcelUtils.createTitleAndModelKey((String)"\u6709\u6548\u671f\u5230", (String)"item.validDateTo");
        validDateToKey.setToObjConverter((StrToObjConverter)dateConverter);
        validDateToKey.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(validDateToKey);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b9a\u4ef7\u65e5\u671f\u63a7\u5236", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea4\u8d27\u5468\u671f", (String)"item.planDeliveryDate"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7ec4", (String)"item.purchaseGroup"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6807\u51c6\u6570\u91cf", (String)"item.purOrderQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u7ec4\u7ec7", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5de5\u5382", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6700\u8fd1\u4e00\u6b21\u91c7\u8d2d\u4e0d\u542b\u7a0e\u5355\u4ef7", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u964d\u798f", (String)"item.decreasingAmplitude"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8003\u96f6\u90e8\u4ef6\u56fe\u53f7", (String)"item.referPartMapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53c2\u8003\u96f6\u90e8\u4ef6\u4ef7\u683c", (String)"item.referPartPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u4ef7\u683c\u8ba1\u91cf\u5355\u4f4d", (String)emptyField));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"item.remark"));
        return titleAndModelKeys;
    }

    private FileData createExcelFileOutputStream(List<TitleAndModelKey> titleAndModelKeys, List<Map<String, Object>> dataList, String title) throws RowsExceededException, WriteException, IOException, ParseException {
        FileData fileData = new FileData();
        String dateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        fileData.setProjectId(ProjectUtils.getProjectId());
        fileData.setCompanyId(CompanyUtils.currentCompanyId());
        fileData.setFileName(MessageFormat.format(title + "-{0}", dateStr) + ".xls");
        fileData.setFileSuffix("xls");
        fileData.setIsEncrypt(String.valueOf(Constant.NO_INT));
        fileData.setExpiryDay(DateUtils.addDays((Date)new Date(), (int)2));
        fileData = FileManagerFactory.getFileManager().write((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), fileData);
        FileOutputStream outputStream = new FileOutputStream(fileData.toFile());
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, dataList, (String)title, null, (int)0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
        return fileData;
    }
}

