/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ApproveSubmitCommand;
import com.els.base.inquiry.command.pur.BatchDeleteCommand;
import com.els.base.inquiry.command.pur.BatchPublishCommand;
import com.els.base.inquiry.command.pur.BatchReQuoteCommand;
import com.els.base.inquiry.command.pur.CancelCommand;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.command.pur.ModifyCommand;
import com.els.base.inquiry.command.pur.PreviewCommand;
import com.els.base.inquiry.command.pur.PreviewMouldListCommand;
import com.els.base.inquiry.command.pur.PreviewTargeListCommand;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.command.pur.PublishCommand;
import com.els.base.inquiry.command.pur.RecallCommand;
import com.els.base.inquiry.command.pur.ViewDetailCommand;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.inquiry.web.vo.MouldTransformVo;
import com.els.base.inquiry.web.vo.ReQuoteVo;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
@Controller
@RequestMapping(value={"purOrder"})
public class PurOrderController {
    @Resource
    protected InquiryCommandInvoker invoker;
    @Resource
    protected PurOrderService purOrderService;
    @Resource
    private InquiryWaitMaterialService inquiryWaitMaterialService;
    @Resource
    private TemplateConfService templateConfService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurOrder purOrder) {
        CreateCommand cmd = new CreateCommand(purOrder);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurOrder purOrder) {
        Assert.isNotBlank((String)purOrder.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyCommand cmd = new ModifyCommand(purOrder);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.purOrderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurOrder>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurOrderExample example = new PurOrderExample();
        example.setPageView((PageView<PurOrder>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_DATE DESC");
        example.createCriteria().andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        PurOrderExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purOrderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=false, value="\u8be2\u4ef7\u5355id", paramType="query", dataType="String", defaultValue="0")})
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurOrder> findById(@RequestParam(required=true) String id) {
        PurOrder order = (PurOrder)this.purOrderService.queryObjById(id);
        Assert.isNotNull((Object)order, (String)"\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728");
        return this.viewPricingDetail(id);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u5934")
    @RequestMapping(value={"service/preview"})
    @ResponseBody
    public ResponseResult<PurOrder> preview(@RequestBody(required=true) WaitMaterialTransformVo vo) {
        PreviewCommand cmd = new PreviewCommand(vo.getTemplateId(), vo.getInquiryWaitMaterials(), vo.getMaterialUsesCode());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        PurOrder order = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)order);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u884c")
    @RequestMapping(value={"service/previewTarget"})
    @ResponseBody
    public ResponseResult<List<ITarget>> previewTarget(@RequestBody(required=true) WaitMaterialTransformVo vo) {
        PreviewTargeListCommand cmd = new PreviewTargeListCommand(vo.getTemplateId(), vo.getInquiryWaitMaterials());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u884c")
    @RequestMapping(value={"service/previewMould"})
    @ResponseBody
    public ResponseResult<List<IMould>> previewMould(@RequestBody(required=true) MouldTransformVo vo) {
        PreviewMouldListCommand cmd = new PreviewMouldListCommand(vo.getTemplateId(), vo.getMouldList());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8be6\u60c5\u754c\u9762")
    @RequestMapping(value={"service/viewDetail"})
    @ResponseBody
    public ResponseResult<PurOrder> viewDetail(@RequestParam(required=true) String purOrderId) {
        ViewDetailCommand cmd = new ViewDetailCommand(purOrderId);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        PurOrder order = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)order);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/publish"})
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody PurOrder purOrder) {
        PublishCommand cmd = new PublishCommand(purOrder);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u5e03\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchPublish"})
    @ResponseBody
    public ResponseResult<String> batchPublish(@RequestBody(required=true) List<String> ids) {
        BatchPublishCommand cmd = new BatchPublishCommand(ids);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u64a4\u56de\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchRecall"})
    @ResponseBody
    public ResponseResult<String> batchRecall(@RequestBody(required=true) List<String> ids) {
        RecallCommand cmd = new RecallCommand(ids);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u4f5c\u5e9f\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchCancel"})
    @ResponseBody
    public ResponseResult<String> batchCancel(@RequestBody(required=true) List<String> ids) {
        CancelCommand cmd = new CancelCommand(ids);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u5220\u9664\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchDelete"})
    @ResponseBody
    public ResponseResult<String> batchDelete(@RequestBody(required=true) List<String> ids) {
        BatchDeleteCommand cmd = new BatchDeleteCommand(ids);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5b9a\u4ef7\u8be6\u60c5\u754c\u9762")
    @RequestMapping(value={"service/viewPricingDetail"})
    @ResponseBody
    public ResponseResult<PurOrder> viewPricingDetail(@RequestParam(required=true) String purOrderId) {
        ViewPricingDetailCommand cmd = new ViewPricingDetailCommand(purOrderId);
        PurOrder purOrder = this.invoker.invoke(cmd);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        return ResponseResult.success((Object)purOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u5b9a\u4ef7\u64cd\u4f5c")
    @RequestMapping(value={"service/pricing"})
    @ResponseBody
    public ResponseResult<String> pricing(@RequestBody(required=true) PurOrder purOrder) {
        PricingCommand cmd = new PricingCommand(purOrder);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u6267\u884c\u91cd\u62a5\u4ef7\u64cd\u4f5c")
    @RequestMapping(value={"service/batchReQuote"})
    @ResponseBody
    public ResponseResult<String> batchReQuote(@RequestBody(required=true) ReQuoteVo reQuoteVo) {
        BatchReQuoteCommand cmd = new BatchReQuoteCommand(reQuoteVo);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/submitToApprove"})
    @ResponseBody
    public ResponseResult<String> submitToApprove(@RequestBody(required=true) ApproveSubmitVo vo) {
        ApproveSubmitCommand cmd = new ApproveSubmitCommand(vo);
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetail"})
    @ResponseBody
    public ResponseResult<BigDecimal> calculateItemDetail(@RequestParam(required=true) String templateId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(templateId);
        DetailDeSerializer<? extends IOrderItemDetail> serializer = new DetailDeSerializer<IOrderItemDetail>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
        IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
        return ResponseResult.success((Object)itemDetail.calculate());
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetailValue"})
    @ResponseBody
    public ResponseResult<List<PropertyValue>> calculateItemDetailValue(@RequestParam(required=true) String templateId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(templateId);
        DetailDeSerializer<? extends IOrderItemDetail> serializer = new DetailDeSerializer<IOrderItemDetail>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
        IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
        itemDetail.calculate();
        itemDetail.setTemplateId(templateId);
        DetailSerialzer<IOrderItemDetail> serialzer = new DetailSerialzer<IOrderItemDetail>();
        return ResponseResult.success(serialzer.getProperyValueClass(itemDetail));
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u62a5\u4ef7\u62a5\u8868\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findReportByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurOrder>> findReportByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurOrderExample example = new PurOrderExample();
        example.setPageView((PageView<PurOrder>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_DATE DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purOrderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

