/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.template.CreateMouldDetailTplCmd;
import com.els.base.inquiry.command.template.DeleteMouldDetailTplCmd;
import com.els.base.inquiry.command.template.ModifyMouldDetailTplCmd;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.utils.ClassReflectionUtils;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f")
@Controller
@RequestMapping(value={"tplMouldDetail"})
public class TplMouldDetailController {
    @Resource
    protected TplMouldDetailService tplMouldDetailService;
    @Resource
    protected PropertyDefService propertyDefService;
    @Resource
    private InquiryCommandInvoker invoker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TplMouldDetail tplMouLdDetail) {
        CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(tplMouLdDetail);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TplMouldDetail tplMouLdDetail) {
        Assert.isNotBlank((String)tplMouLdDetail.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyMouldDetailTplCmd cmd = new ModifyMouldDetailTplCmd(tplMouLdDetail);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> idList) {
        Assert.isNotEmpty(idList, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteMouldDetailTplCmd cmd = new DeleteMouldDetailTplCmd(idList);
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f\u521b\u5efa\u9884\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="className", required=false, value="\u6a21\u677f\u6307\u5b9a\u7c7b\u540d(\u975e\u5fc5\u586b)", paramType="query", dataType="String", defaultValue="0")})
    @RequestMapping(value={"service/preview"})
    @ResponseBody
    public ResponseResult<TplMouldDetail> preview(String className) {
        Class clazz = null;
        clazz = StringUtils.isNotBlank((String)className) ? ClassReflectionUtils.getClassByName(className) : InquiryConstant.DEFALUT_MOULD_DETAIL_CLS;
        TplMouldDetail tplMouLdDetail = new TplMouldDetail();
        String dateFormat = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        tplMouLdDetail.setCode(String.format("TPL_MOULD_DETAIL_%s", dateFormat));
        tplMouLdDetail.setName(String.format("\u6a21\u5177\u6210\u672c\u6e05\u5355%s", dateFormat));
        tplMouLdDetail.setPropertyDefList(PropertyDefUtils.getProperyDefByClass(clazz));
        return ResponseResult.success((Object)tplMouLdDetail);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u6a21\u5177\u6210\u672c\u6e05\u5355\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 TplMouLdDetail", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<TplMouldDetail>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        TplMouldDetailExample example = new TplMouldDetailExample();
        example.setPageView((PageView<TplMouldDetail>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        TplMouldDetailExample.Criteria criteria = example.createCriteria();
        criteria.andIsHisEqualTo(Constant.NO_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.tplMouldDetailService.queryObjByPage((IExample)example);
        for (TplMouldDetail tplMouldDetail : pageData.getQueryResult()) {
            tplMouldDetail.setPropertyDefList(PropertyDefUtils.queryMouldDetailProDef(tplMouldDetail));
        }
        return ResponseResult.success((Object)pageData);
    }
}

