/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.log.entity.InterfaceLog;
import com.els.base.log.entity.InterfaceLogExample;
import com.els.base.log.service.InterfaceLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868"})
@Controller
@RequestMapping(value={"interfaceLog"})
public class InterfaceLogController {
    @Resource
    protected InterfaceLogService interfaceLogService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody InterfaceLog interfaceLog) {
        this.interfaceLogService.addObj(interfaceLog);
        return ResponseResult.success((Object)interfaceLog.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody InterfaceLog interfaceLog) {
        Assert.isNotBlank((String)interfaceLog.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.interfaceLogService.modifyObj(interfaceLog);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        InterfaceLogExample example = new InterfaceLogExample();
        example.createCriteria().andIdIn((List)ids);
        this.interfaceLogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.interfaceLogService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u63a5\u53e3\u65e5\u5fd7\u4e2d\u95f4\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 InterfaceLog", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<InterfaceLog>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        InterfaceLogExample example = new InterfaceLogExample();
        example.setPageView((PageView<InterfaceLog>)new PageView(pageNo, pageSize));
        InterfaceLogExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.interfaceLogService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5355\u4e2a\u63a5\u53e3\u65e5\u5fd7\u5bf9\u8c61")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<InterfaceLog> findById(@RequestParam(required=true) String id) {
        return ResponseResult.success((Object)this.interfaceLogService.queryObjById(id));
    }
}

