-- ----------------------------
-- 接口日志表
-- ----------------------------
-- DROP TABLE "T_BASE_INTERFACE_LOG";
CREATE TABLE "T_BASE_INTERFACE_LOG"
(
    "ID"                   VARCHAR2(32) NOT NULL,
    "INTERFACE_CODE"       VARCHAR2(255),
    "INTERFACE_NAME"       VARCHAR2(255),
    "INTERFACE_TYPE"       VARCHAR2(50),
    "INTERFACE_VALUE"      VARCHAR2(255),
    "INTERFACE_STATUS"     VARCHAR2(10),
    "BILL_CODE"            VARCHAR2(50),
    "BIIL_LINENO"          VARCHAR2(20),
    "BILL_TYPE"            VARCHAR2(255),
    "SUCCESS_COUNT"        NUMBER(11),
    "ERROR_COUNT"          NUMBER(11),
    "INTERFACE_CONTENT"    NCLOB,
    "CREATE_TIME"          DATE,
    "CREATE_USER"          VARCHAR2(255),
    "INTERFACE_BEGINTIME"  DATE,
    "INTERFACE_ENDTIME"    DATE,
    "INTERFACE_DURATION"   VARCHAR2(255),
    "INTERFACE_REQUEST"    CLOB,
    "INTERFACE_RESPONSE"   CLOB,
    "INTERFACE_FAILREASON" CLOB,
    "INTERFACE_REQURL"     VARCHAR2(500),
    "ATTRIBUTE1"           VARCHAR2(255),
    "ATTRIBUTE2"           VARCHAR2(255),
    "ATTRIBUTE3"           VARCHAR2(255),
    "ATTRIBUTE4"           VARCHAR2(255),
    "ATTRIBUTE5"           VARCHAR2(255)
);

COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_CODE" IS '接口代码';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_NAME" IS '接口名称';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_TYPE" IS '接口类型';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_VALUE" IS '接口值';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_STATUS" IS '是否成功 Y/N';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."BILL_CODE" IS '单据代码';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."BIIL_LINENO" IS '单据行号';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."BILL_TYPE" IS '单据类型';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."SUCCESS_COUNT" IS '成功条数';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ERROR_COUNT" IS '失败条数';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_CONTENT" IS '接口消息内容';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_BEGINTIME" IS '接口开始时间';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_ENDTIME" IS '接口结束时间';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_DURATION" IS '持续时间 毫秒(f)';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_REQUEST" IS '请求参数';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_RESPONSE" IS '返回结果';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_FAILREASON" IS '失败原因';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."INTERFACE_REQURL" IS '请求URL';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ATTRIBUTE1" IS '备用字段1';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ATTRIBUTE2" IS '备用字段2';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ATTRIBUTE3" IS '备用字段3';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ATTRIBUTE4" IS '备用字段4';
COMMENT ON COLUMN "T_BASE_INTERFACE_LOG"."ATTRIBUTE5" IS '备用字段5';
COMMENT ON TABLE "T_BASE_INTERFACE_LOG" IS '接口日志中间表';

ALTER TABLE "T_BASE_INTERFACE_LOG" ADD PRIMARY KEY ("ID");