/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.log.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.log.dao.InterfaceLogMapper;
import com.els.base.log.entity.InterfaceLog;
import com.els.base.log.entity.InterfaceLogExample;
import com.els.base.log.service.InterfaceLogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultInterfaceLogService")
public class InterfaceLogServiceImpl
implements InterfaceLogService {
    @Resource
    protected InterfaceLogMapper interfaceLogMapper;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private GenerateCodeService generateCodeService;

    @Override
    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void save(InterfaceLog interfaceLog) {
        String nextCode = this.generateCodeService.getNextCode("INTERFACE_CODE");
        interfaceLog.setInterfaceCode(nextCode);
        interfaceLog.setCreateTime(new Date());
        if (ObjectUtil.isEmpty((Object)interfaceLog.getInterfaceBegintime())) {
            interfaceLog.setInterfaceBegintime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)interfaceLog.getInterfaceEndtime())) {
            interfaceLog.setInterfaceEndtime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)interfaceLog.getSuccessCount())) {
            interfaceLog.setSuccessCount(Constant.YES_INT);
        }
        if (ObjectUtil.isEmpty((Object)interfaceLog.getErrorCount())) {
            interfaceLog.setErrorCount(Constant.NO_INT);
        }
        if (ObjectUtil.isEmpty((Object)interfaceLog.getInterfaceStatus())) {
            interfaceLog.setInterfaceStatus("Y");
        }
        this.threadPoolTaskExecutor.execute(() -> this.interfaceLogMapper.insertSelective(interfaceLog));
    }

    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void addObj(InterfaceLog t) {
        this.interfaceLogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void addAll(List<InterfaceLog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.interfaceLogMapper.insertBatch(list);
    }

    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.interfaceLogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void deleteByExample(InterfaceLogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.interfaceLogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"interfaceLog"}, allEntries=true)
    public void modifyObj(InterfaceLog t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.interfaceLogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"interfaceLog"}, keyGenerator="redisKeyGenerator")
    public InterfaceLog queryObjById(String id) {
        return this.interfaceLogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"interfaceLog"}, keyGenerator="redisKeyGenerator")
    public List<InterfaceLog> queryAllObjByExample(InterfaceLogExample example) {
        return this.interfaceLogMapper.selectByExample(example);
    }

    @Cacheable(value={"interfaceLog"}, keyGenerator="redisKeyGenerator")
    public PageView<InterfaceLog> queryObjByPage(InterfaceLogExample example) {
        PageView<InterfaceLog> pageView = example.getPageView();
        pageView.setQueryResult(this.interfaceLogMapper.selectByExampleByPage(example));
        return pageView;
    }
}

