/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.codegenerator.service.impl;

import com.els.base.codegenerator.entity.GenerateCode;
import com.els.base.codegenerator.service.GenerateStrategy;
import com.els.base.core.exception.CommonException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Component;

@Component
public class DateIncrementStrategy
extends GenerateStrategy {
    private String dateFormatter = "yyyyMMdd";

    @Override
    public List<String> generateNextCode(GenerateCode currentCode, int quantity) {
        String code = currentCode.getCurrentCode();
        if (StringUtils.isBlank((String)code)) {
            code = currentCode.getStartCode();
        }
        if (StringUtils.isBlank((String)code)) {
            throw new CommonException("\u914d\u7f6e\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u89c4\u5219\u4e2d\uff0c\u6ca1\u6709\u8d77\u59cb\u7f16\u7801");
        }
        String maxCode = currentCode.getMaxCode();
        if (StringUtils.isBlank((String)maxCode)) {
            maxCode = "9999999";
        }
        if (StringUtils.isNotBlank((String)maxCode) && !StringUtils.isNumeric((String)maxCode)) {
            throw new CommonException("\u914d\u7f6e\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u89c4\u5219\u4e2d\uff0c\u6700\u5927\u503c\u53c2\u6570\u5f02\u5e38");
        }
        int maxLength = maxCode.length();
        ArrayList<String> nextCodes = new ArrayList<String>(quantity);
        for (int i = 0; i < quantity; ++i) {
            String date = DateFormatUtils.format((Date)new Date(), (String)this.dateFormatter);
            if (!code.contains(date)) {
                code = currentCode.getStartCode();
            } else {
                code = code.replaceAll(date, "");
                BigDecimal bigDecimal = new BigDecimal(code);
                code = bigDecimal.add(new BigDecimal(1)).toString();
            }
            BigDecimal maxCodeBd = new BigDecimal(maxCode);
            if (maxCodeBd.compareTo(new BigDecimal(code)) < 0) {
                throw new CommonException("\u6d41\u6c34\u53f7\u5df2\u7ecf\u5230\u4e86\u6700\u5927\u503c\uff0c\u65e0\u6cd5\u751f\u6210\u6d41\u6c34\u53f7\u4e86");
            }
            code = date + StringUtils.leftPad((String)code, (int)maxLength, (String)"0");
            nextCodes.add(new String(code));
        }
        return nextCodes;
    }

    public static void main(String[] args) {
        DateIncrementStrategy strategy = new DateIncrementStrategy();
        GenerateCode code = new GenerateCode();
        code.setStartCode("1");
        code.setCurrentCode("2017082899998");
        code.setMaxCode("99999");
        try {
            System.out.println(strategy.generateNextCode(code, 5));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

