/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.utils.query;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.query.OrderByParam;
import com.els.base.core.utils.query.QueryParam;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.json.JsonUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParamWapperDeserializer
extends JsonDeserializer<QueryParamWapper> {
    private static final Logger logger = LoggerFactory.getLogger(QueryParamWapperDeserializer.class);
    private static final String separator = "_$_";
    private static final String ORDER_BY_KEY_REGEX = "^\\s*\\$orderBy\\s*";

    public QueryParamWapper deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken != JsonToken.START_OBJECT) {
            throw new CommonException("\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0c\u65e0\u6cd5\u89e3\u6790", "unable_to_parse");
        }
        JsonDeserializer des = JsonNodeDeserializer.getDeserializer(ObjectNode.class);
        ObjectNode objectNode = (ObjectNode)des.deserialize(jp, ctxt);
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        List<OrderByParam> orderByParams = new ArrayList<OrderByParam>();
        Iterator fieldNames = objectNode.fieldNames();
        while (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            String value = null;
            JsonNode valueNode = objectNode.get(key);
            value = valueNode instanceof TextNode ? valueNode.asText() : valueNode.toString();
            if (key.matches(ORDER_BY_KEY_REGEX)) {
                orderByParams = this.getOrderBy(value);
                continue;
            }
            queryParams.add(this.newQueryParam(key, value));
        }
        QueryParamWapper wapper = new QueryParamWapper();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            wapper.setQueryParams(queryParams);
        }
        if (CollectionUtils.isNotEmpty(orderByParams)) {
            wapper.setOrderByParams(orderByParams);
        }
        return wapper;
    }

    private List<OrderByParam> getOrderBy(String value) {
        List valueList;
        if (StringUtils.isBlank((String)value) || value.trim().matches("\\[\\s*\\]")) {
            return null;
        }
        try {
            valueList = (List)JsonUtils.convertCollection((String)value, List.class, null, (Class[])new Class[]{OrderByParam.class});
        }
        catch (Exception exception) {
            String msg = MessageFormat.format("$orderBy\u7684\u683c\u5f0f\u4e0d\u6b63\u786e[{0}]", value);
            logger.error(msg, (Throwable)exception);
            throw new CommonException(msg);
        }
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            return null;
        }
        return valueList;
    }

    private QueryParam newQueryParam(String key, String value) {
        if (!key.contains(separator)) {
            String errMsg = MessageFormat.format("\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0ckey[{0}]\u7f3a\u5c11\u5173\u952e\u5b57\"_$_\"", key);
            throw new CommonException(errMsg, "unable_to_parse");
        }
        String[] propertyAndCondition = key.split("_\\$_");
        if (propertyAndCondition.length < 2 || StringUtils.isBlank((String)propertyAndCondition[1])) {
            String errMsg = MessageFormat.format("\u53c2\u6570\u683c\u5f0f\u5f02\u5e38\uff0ckey[{0}]\u5173\u952e\u5b57\"_$_\"\u540e\u9762\u7f3a\u5c11\u67e5\u8be2\u6761\u4ef6", key);
            throw new CommonException(errMsg, "unable_to_parse");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.setProperty(propertyAndCondition[0]);
        queryParam.setCondition(propertyAndCondition[1]);
        queryParam.setValue(value);
        return queryParam;
    }

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        String str = "{\"name_$_eq\":\"abc\",   \"abc_$_neq\":[\"bcd\",\"adfs\"], \"$orderBy\":[\"abcEfgWe desc\"]}";
        ObjectMapper objectMapper = new ObjectMapper();
        QueryParamWapper wapper = (QueryParamWapper)objectMapper.readValue(str, QueryParamWapper.class);
        System.out.println(wapper.getQueryParams());
        System.out.println(wapper.getOrderBy());
    }
}

