/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.utils.excel.BigDecimalConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(value="\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
@Controller
@RequestMapping(value={"companySapRelation"})
public class CompanySapRelationController {
    @Resource
    protected CompanySapRelationService companySapRelationService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanySapRelation companySapRelation) {
        if (companySapRelation == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companySapRelationService.addObj(companySapRelation);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanySapRelation companySapRelation) {
        if (companySapRelation == null) {
            throw new CommonException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)companySapRelation.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.companySapRelationService.modifyObj(companySapRelation);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companySapRelationService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanySapRelation", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanySapRelation>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanySapRelationExample example = new CompanySapRelationExample();
        example.setPageView(new PageView<CompanySapRelation>(pageNo, pageSize));
        if (wapper != null) {
            CompanySapRelationExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companySapRelationService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanySapRelation", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/selectQualifiedSapRelationByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanySapRelation>> selectQualifiedSapRelationByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam String queryParam, @RequestParam(defaultValue="qualified") String roleEnum) {
        ArrayList<String> roleEnumList = new ArrayList<String>();
        roleEnumList.add(PartnerRoleEnum.STRANGER.getCode());
        roleEnumList.add(PartnerRoleEnum.QUALIFIED.getCode());
        roleEnumList.add(PartnerRoleEnum.POTENIAL.getCode());
        roleEnumList.add(PartnerRoleEnum.ELIMINATE.getCode());
        roleEnumList.add(PartnerRoleEnum.BOUNDED.getCode());
        roleEnumList.add(PartnerRoleEnum.WAIT_ELIMINATE.getCode());
        if (!roleEnumList.contains(roleEnum)) {
            throw new CommonException("\u4e0d\u652f\u6301\u8be5\u89d2\u8272\u67e5\u8be2\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5!");
        }
        CompanySapRelationExample example = new CompanySapRelationExample();
        example.setPageView(new PageView<CompanySapRelation>(pageNo, pageSize));
        CompanySapRelationExample.Criteria criteria = example.createCriteria();
        criteria.andIdIsNotNull();
        if (StringUtils.isNotBlank((String)queryParam)) {
            criteria.andCompanyCodeLike("%" + queryParam + "%");
            example.or().andSapSupplierCodeLike("%" + queryParam + "%");
            example.or().andCompanyFullNameLike("%" + queryParam + "%");
        }
        PageView<CompanySapRelation> pageData = this.companySapRelationService.selectQualifiedSapRelationByPage(ProjectUtils.getCompanyId(), example, roleEnum);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u68c0\u67e5SAP\u4f9b\u5e94\u5546\u7f16\u7801\u5728\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"service/checkSapSuppliterCodeIfExist/{code}"})
    @ResponseBody
    public ResponseResult<Integer> checkSapSuppliterCodeIfExist(@PathVariable String code) {
        boolean flag = this.companySapRelationService.checkSapSupplierCodeIfExist(code, null);
        if (flag) {
            return ResponseResult.success(1);
        }
        return ResponseResult.success(0);
    }

    @ApiOperation(httpMethod="POST", value="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5173\u8054\u7684\u4f9b\u5e94\u5546SAP\u7f16\u7801")
    @RequestMapping(value={"service/currentSapCode"})
    @ResponseBody
    public ResponseResult<List<String>> currentSapCode() {
        String companyCode = CompanyUtils.currentCompany().getCompanyCode();
        List<String> sapCodes = this.companySapRelationService.findSapCodeByCompanyCode(companyCode);
        return ResponseResult.success(sapCodes);
    }

    @ApiOperation(httpMethod="GET", value="\u5bfc\u51faEXCEL")
    @RequestMapping(value={"service/exportToExcel"})
    @ResponseBody
    public void exportToExcel(HttpServletResponse response) {
        try {
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            header.append("filename=\"" + URLEncoder.encode("SAP\u4f9b\u5e94\u5546\u7f16\u7801\u5173\u7cfb\u6570\u636e.xls", "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)outputStream, titleAndModelKeys, null, (String)"SAP\u4f9b\u5e94\u5546\u7f16\u7801\u5173\u7cfb\u6570\u636e", null, (int)0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(417);
        }
    }

    @ApiOperation(value="\u5bfc\u5165Excel", httpMethod="POST")
    @RequestMapping(value={"service/importFromExcel"})
    @ResponseBody
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) {
        Map fileMap = request.getFileMap();
        MultipartFile file = this.vaildFile(fileMap);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumn();
        try {
            List list = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, titleAndModelKeys, CompanySapRelation.class);
            this.companySapRelationService.importFromExcel(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8d26\u53f7\u4e0e\u4f9b\u5e94\u5546\u5173\u8054\u5173\u7cfb\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody Set<String> ids) {
        this.companySapRelationService.deleteByIds(ids);
        return ResponseResult.success();
    }

    private MultipartFile vaildFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        Set<String> fileKeySet = fileMap.keySet();
        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }
        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("\u5bfc\u5165\u6587\u4ef6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u76ee\u524d\u53ea\u652f\u6301xls");
        }
        return file;
    }

    private List<TitleAndModelKey> createExcelHeaderColumn() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SAP\u7f16\u7801", (String)"sapSupplierCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5168\u79f0", (String)"companyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u82f1\u6587\u5168\u79f0", (String)"companyFullEnName"));
        TitleAndModelKey taxRate = ExcelUtils.createTitleAndModelKey((String)"\u7a0e\u7387", (String)"taxRate");
        taxRate.setToObjConverter((StrToObjConverter)new BigDecimalConverter());
        taxRate.setToStrConverter((ObjToStrConverter)new BigDecimalConverter());
        titleAndModelKeys.add(taxRate);
        return titleAndModelKeys;
    }
}

