/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f01\u4e1a\u7528\u6237\u5173\u8054\u8868")
@Controller
@RequestMapping(value={"companyUserRef"})
public class CompanyUserRefController {
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    private UserService userService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f01\u4e1a\u7528\u6237\u5173\u8054\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyUserRef companyUserRef) {
        this.companyUserRefService.addObj(companyUserRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f01\u4e1a\u7528\u6237\u5173\u8054\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyUserRef companyUserRef) {
        if (StringUtils.isBlank((String)companyUserRef.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.companyUserRefService.modifyObj(companyUserRef);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f01\u4e1a\u7528\u6237\u5173\u8054\u8868")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.companyUserRefService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f01\u4e1a\u7528\u6237\u5173\u8054\u8868")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyUserRef>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyUserRef") @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.setPageView(new PageView<CompanyUserRef>(pageNo, pageSize));
        if (wapper != null) {
            CompanyUserRefExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.companyUserRefService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value="\u6dfb\u52a0\u7528\u6237\u5e10\u53f7", httpMethod="POST")
    @RequestMapping(value={"service/addUser"})
    @ResponseBody
    public ResponseResult<String> addUser(@RequestBody User user) {
        if (StringUtils.isBlank((String)user.getEmail())) {
            throw new CommonException("Email\u503c\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "Email");
        }
        if (StringUtils.isBlank((String)user.getLoginName())) {
            throw new CommonException("\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u8d26\u53f7");
        }
        if (StringUtils.isBlank((String)user.getMobilePhone())) {
            throw new CommonException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u624b\u673a\u53f7");
        }
        if (StringUtils.isBlank((String)user.getPassword())) {
            throw new CommonException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u5bc6\u7801");
        }
        if (user.getLoginName().length() > 255) {
            throw new CommonException("\u7528\u6237\u8d26\u53f7\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", "\u7528\u6237\u8d26\u53f7\u540d\u79f0", 255);
        }
        if (user.getMobilePhone().length() > 11) {
            throw new CommonException("\u7528\u6237\u624b\u673a\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", "\u7528\u6237\u624b\u673a\u53f7", 11);
        }
        if (user.getEmail().length() > 255) {
            throw new CommonException("\u7528\u6237\u90ae\u7bb1\u53f7\u4e0d\u80fd\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6", "length_canot_exceed", "\u7528\u6237\u90ae\u7bb1\u53f7", 255);
        }
        user.setId(null);
        user.setIsEnable(Constant.YES_INT);
        user.setProjectCode(ProjectUtils.getProject().getProjectCode());
        this.userService.addObj(user);
        CompanyUserRef companyUserRef = new CompanyUserRef();
        companyUserRef.setProjectId(ProjectUtils.getProjectId());
        companyUserRef.setCompanyId(CompanyUtils.currentCompanyId());
        companyUserRef.setUserId(user.getId());
        companyUserRef.setCreateTime(new Date());
        this.companyUserRefService.addObj(companyUserRef);
        return ResponseResult.success();
    }
}

