/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.entity;

import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageView<T extends Serializable>
implements Serializable {
    private static final Integer MIN_PAGE_NO = 1;
    private static final Integer MAX_PAGE_SIZE = 1000;
    private static final Integer DEFAULT_PAGE_NO = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 10;
    private static Logger logger = LoggerFactory.getLogger(PageView.class);
    private static final long serialVersionUID = 7524772792315029450L;
    private int pageNo = DEFAULT_PAGE_NO;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private int pageCount;
    private int rowCount;
    private int startRowNo;
    private int endRowNo;
    private List<T> queryResult;

    public PageView() {
    }

    public PageView(int pageNo, int pageSize) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.checkPageParams();
        this.initRowIndexNO();
    }

    private void checkPageParams() {
        if (this.pageNo < MIN_PAGE_NO) {
            logger.warn("\u8b66\u544a\uff01\uff01\u53c2\u6570\u4e2d\u5206\u7801\u4f4e\u4e8e\u6700\u5c0f\u53c2\u6570\u3002\u6700\u5927\u53c2\u6570\u30101\u3011,\u5f53\u524d\u9875\u7801\u3010{}\u3011,\u9875\u7801\u6539\u4e3a1\u3002", (Object)this.pageNo);
            this.pageNo = 1;
        }
        if (this.pageSize > MAX_PAGE_SIZE) {
            logger.warn("\u8b66\u544a\uff01\uff01\uff01\u53c2\u6570\u4e2d\u5206\u9875\u5927\u5c0f\u8d85\u51fa\u6700\u5927\u53c2\u6570\u3002\u6700\u5927\u53c2\u6570\u3010500\u3011,\u5f53\u524d\u5927\u5c0f\u3010{}\u3011,\u5c06\u6709\u6027\u80fd\u98ce\u9669\u3002", (Object)this.pageSize);
        }
    }

    private void initRowIndexNO() {
        this.startRowNo = (this.pageNo - 1) * this.pageSize;
        this.endRowNo = this.pageNo * this.pageSize;
        if (this.startRowNo < 0) {
            this.startRowNo = 0;
        }
        if (this.endRowNo >= this.rowCount) {
            this.endRowNo = this.rowCount;
        }
    }

    private void initPageCount() {
        int n = this.pageCount = this.rowCount % this.pageSize == 0 ? this.rowCount / this.pageSize : this.rowCount / this.pageSize + 1;
        if (this.pageNo > this.pageCount) {
            this.pageNo = this.pageCount;
        }
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
        this.initPageCount();
        this.initRowIndexNO();
    }

    public int getiTotalRecords() {
        return this.getRowCount();
    }

    public int getiTotalDisplayRecords() {
        return this.getRowCount();
    }

    public int getStartRowNo() {
        return this.startRowNo;
    }

    public int getEndRowNo() {
        return this.endRowNo;
    }

    public List<T> getQueryResult() {
        return this.queryResult;
    }

    public PageView<T> setQueryResult(List<T> result) {
        this.queryResult = result;
        return this;
    }
}

