/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.plugin.redis;

import com.els.base.core.plugin.redis.RedisKey;
import com.els.base.utils.encryption.Md5Utils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;

public class RedisKeyGenerator
implements KeyGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object generate(Object target, Method method, Object ... params) {
        String redisKeyStr = null;
        this.logger.trace("start generate redis key");
        try {
            RedisKey redisKey = new RedisKey();
            redisKey.setClassName(target.getClass().getName());
            redisKey.setMethodName(method.getName());
            redisKey.setParams(this.getParamsMap(method, params));
            redisKeyStr = Md5Utils.md5Object((Object)redisKey);
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210redis-key\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.logger.trace("finish generate redis key : " + redisKeyStr);
        return redisKeyStr;
    }

    private List<Map<String, Object>> getParamsMap(Method method, Object ... params) throws NoSuchAlgorithmException, UnsupportedEncodingException, JsonProcessingException {
        if (params == null || params.length == 0) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList<Map<String, Object>> paramsMap = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < params.length; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(paramTypes[i].getName(), Md5Utils.md5Object((Object)params[i]));
            paramsMap.add(map);
        }
        return paramsMap;
    }
}

