/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.controller.dictionary;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5b57\u5178\u7ec4")
@Controller
@RequestMapping(value={"dicGroup"})
public class DicGroupController {
    @Resource
    protected DicGroupService dicGroupService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5b57\u5178\u7ec4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DicGroup dicGroup) {
        this.dicGroupValidtion(dicGroup);
        this.dicGroupService.addObj(dicGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5b57\u5178\u7ec4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DicGroup dicGroup) {
        this.dicGroupValidtion(dicGroup);
        this.dicGroupService.modifyObj(dicGroup);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5b57\u5178\u7ec4")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.dicGroupService.deleteObjById(id);
        return ResponseResult.success();
    }

    private void dicGroupValidtion(DicGroup dicGroup) {
        List<DicGroup> list;
        if (dicGroup == null || StringUtils.isBlank((String)dicGroup.getCode()) || StringUtils.isBlank((String)dicGroup.getName())) {
            throw new CommonException("\u53c2\u6570\u4e0d\u5b8c\u6574\uff0c\u8bf7\u586b\u5199\u5fc5\u8981\u7684\u4fe1\u606f", "parameter_incomplete");
        }
        if (StringUtils.isBlank((String)dicGroup.getCode()) || !dicGroup.getCode().matches("[\\w\\d\\_\\-]+")) {
            throw new CommonException("\u5b57\u5178\u7ec4code\u683c\u5f0f\u4e0d\u6b63\u786e", "base_invaild_format", "\u5b57\u5178\u7ec4code");
        }
        DicGroupExample example = new DicGroupExample();
        DicGroupExample.Criteria cri = example.createCriteria();
        cri.andCodeEqualTo(dicGroup.getCode());
        if (dicGroup.getId() != null) {
            cri.andIdNotEqualTo(dicGroup.getId());
        }
        if ((list = this.dicGroupService.queryAllObjByExample(example)).size() > 0) {
            throw new CommonException("code\u5fc5\u987b\u552f\u4e00\uff0c\u8be5\u5b57\u5178\u7ec4\u4e2d\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684code", "base_is_exists", "code");
        }
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5b57\u5178\u7ec4")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DicGroup>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u7684\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") @RequestBody(required=false) List<QueryParam> queryParams) {
        DicGroupExample example = new DicGroupExample();
        example.setPageView(new PageView<DicGroup>(pageNo, pageSize));
        example.setOrderByClause("ID DESC");
        DicGroupExample.Criteria criteria = example.createCriteria();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }
        PageView<DicGroup> pageView = this.dicGroupService.queryObjByPage(example);
        return ResponseResult.success(pageView);
    }
}

