/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.entity.MaterialPropKey;
import com.els.base.material.entity.MaterialPropKeyExample;
import com.els.base.material.entity.MaterialPropKeyGroup;
import com.els.base.material.entity.MaterialPropKeyGroupExample;
import com.els.base.material.entity.MaterialPropValue;
import com.els.base.material.entity.MaterialPropValueExample;
import com.els.base.material.service.MaterialPropKeyGroupService;
import com.els.base.material.service.MaterialPropKeyService;
import com.els.base.material.service.MaterialPropValueService;
import com.els.base.material.service.MaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u7269\u6599")
@Controller
@RequestMapping(value={"material"})
public class MaterialController {
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialPropKeyGroupService materialPropKeyGroupService;
    @Resource
    protected MaterialPropKeyService materialPropKeyService;
    @Resource
    protected MaterialPropValueService materialPropValueService;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u7269\u6599")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Material>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Material") @RequestBody(required=false) QueryParamWapper queryParamWapper) {
        MaterialExample example = new MaterialExample();
        example.setPageView(new PageView<Material>(pageNo, pageSize));
        example.setOrderByClause("MATERIAL_CODE ASC");
        MaterialExample.Criteria criteria = example.createCriteria();
        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        criteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.materialService.queryObjByPage(example);
        List materialList = pageData.getQueryResult();
        if (CollectionUtils.isNotEmpty(materialList)) {
            for (Material material : materialList) {
                if (StringUtils.isBlank((String)material.getCategoryId())) continue;
                MaterialPropKeyGroupExample materialPropKeyGroupExample = new MaterialPropKeyGroupExample();
                MaterialPropKeyGroupExample.Criteria materialPropKeyGroupExampleCriteria = materialPropKeyGroupExample.createCriteria();
                materialPropKeyGroupExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                materialPropKeyGroupExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                materialPropKeyGroupExampleCriteria.andMaterialCategoryIdEqualTo(material.getCategoryId());
                List<MaterialPropKeyGroup> materialPropKeyGroupList = this.materialPropKeyGroupService.queryAllObjByExample(materialPropKeyGroupExample);
                if (CollectionUtils.isNotEmpty(materialPropKeyGroupList)) {
                    for (MaterialPropKeyGroup materialPropKeyGroup : materialPropKeyGroupList) {
                        MaterialPropKeyExample materialPropKeyExampleExample = new MaterialPropKeyExample();
                        MaterialPropKeyExample.Criteria materialPropKeyExampleCriteria = materialPropKeyExampleExample.createCriteria();
                        materialPropKeyExampleCriteria.andProjectIdEqualTo(ProjectUtils.getProjectId());
                        materialPropKeyExampleCriteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
                        materialPropKeyExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                        List<MaterialPropKey> materialPropKeyList = this.materialPropKeyService.queryAllObjByExample(materialPropKeyExampleExample);
                        if (CollectionUtils.isNotEmpty(materialPropKeyList)) {
                            for (MaterialPropKey materialPropKey : materialPropKeyList) {
                                MaterialPropValueExample materialPropValueExample = new MaterialPropValueExample();
                                MaterialPropValueExample.Criteria materialPropValueExampleCriteria = materialPropValueExample.createCriteria();
                                materialPropValueExampleCriteria.andProjectIdEqualTo(material.getProjectId());
                                materialPropValueExampleCriteria.andCompanyIdEqualTo(material.getCompanyId());
                                materialPropValueExampleCriteria.andMaterialIdEqualTo(material.getId());
                                materialPropValueExampleCriteria.andPropKeyGroupIdEqualTo(materialPropKeyGroup.getId());
                                materialPropValueExampleCriteria.andPropKeyIdEqualTo(materialPropKey.getId());
                                materialPropValueExampleCriteria.andPropKeyEqualTo(materialPropKey.getPropKey());
                                List materialPropValueList = this.materialPropValueService.queryAllObjByExample(materialPropValueExample);
                                if (!CollectionUtils.isNotEmpty(materialPropValueList) || materialPropValueList.size() <= 0) continue;
                                MaterialPropValue materialPropValue = (MaterialPropValue)materialPropValueList.get(0);
                                materialPropKey.setPropValue(materialPropValue.getPropValue());
                            }
                        }
                        materialPropKeyGroup.setMaterialPropKeyList(materialPropKeyList);
                    }
                }
                material.setMaterialPropKeyGroupList(materialPropKeyGroupList);
            }
        }
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u542f\u7528/\u7981\u6b62\u7269\u6599\u4fe1\u606f")
    @RequestMapping(value={"service/isEnable"})
    @ResponseBody
    public ResponseResult<Integer> isEnable(@ApiParam(value="\u7269\u6599id") String id, @ApiParam(value="\u542f\u7528\u4f201,\u7981\u7528\u4f200") Integer isEnable) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e3a\u7a7a,\u542f\u7528/\u7981\u6b62\u4f01\u4e1a\u5931\u8d25", "id_is_blank");
        }
        int result = this.materialService.isEnable(id, isEnable);
        return ResponseResult.success(result);
    }
}

