CREATE TABLE "T_BASE_COMPANY_SAP_RELATION" (
"ID" NVARCHAR2(32) NOT NULL ,
"COMPANY_CODE" NVARCHAR2(32) NOT NULL ,
"SAP_SUPPLIER_CODE" NVARCHAR2(32) NOT NULL ,
"COMPANY_NAME" NVARCHAR2(255) NULL ,
"COMPANY_FULL_NAME" NVARCHAR2(255) NULL 
);

COMMENT ON TABLE "T_BASE_COMPANY_SAP_RELATION" IS '账号与供应商关联关系表';
COMMENT ON COLUMN "T_BASE_COMPANY_SAP_RELATION"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_COMPANY_SAP_RELATION"."COMPANY_CODE" IS '用户编码';
COMMENT ON COLUMN "T_BASE_COMPANY_SAP_RELATION"."SAP_SUPPLIER_CODE" IS 'SAP供应商编码';
COMMENT ON COLUMN "T_BASE_COMPANY_SAP_RELATION"."COMPANY_NAME" IS '客户名称';
COMMENT ON COLUMN "T_BASE_COMPANY_SAP_RELATION"."COMPANY_FULL_NAME" IS '公司全称';

ALTER TABLE "T_BASE_COMPANY_SAP_RELATION" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_SAP_RELATION" ADD CHECK ("COMPANY_CODE" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_SAP_RELATION" ADD CHECK ("SAP_SUPPLIER_CODE" IS NOT NULL);

ALTER TABLE "T_BASE_COMPANY_SAP_RELATION" ADD PRIMARY KEY ("ID");
