/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.core.web.context.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class McodingBeanDefinitionReader
extends XmlBeanDefinitionReader {
    public McodingBeanDefinitionReader(BeanDefinitionRegistry registry) {
        super(registry);
    }

    public int loadBeanDefinitions(String location, Set<Resource> actualResources) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                resources = this.filte(resources);
                resources = this.sort(resources);
                int loadCount = this.loadBeanDefinitions(resources);
                if (actualResources != null) {
                    for (Resource resource : resources) {
                        actualResources.add(resource);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location pattern [" + location + "]"));
                }
                return loadCount;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", (Throwable)ex);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        int loadCount = this.loadBeanDefinitions(resource);
        if (actualResources != null) {
            actualResources.add(resource);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location [" + location + "]"));
        }
        return loadCount;
    }

    private Resource[] sort(Resource[] source) {
        Assert.notNull((Object)source, (String)"spring\u7684\u914d\u7f6e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        String[] configFileQueue = new String[]{"spring-context.xml", "spring-mvc-i18n.xml", "spring-security.xml", "spring-mvc.xml"};
        final HashMap<String, Integer> configFileAndSortNo = new HashMap<String, Integer>();
        for (int i = 0; i < configFileQueue.length; ++i) {
            configFileAndSortNo.put(configFileQueue[i], i);
        }
        List<Resource> sourceList = Arrays.asList(source);
        Collections.sort(sourceList, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                Integer sortNo1 = (Integer)configFileAndSortNo.get(o1.getFilename());
                sortNo1 = sortNo1 == null ? Integer.MAX_VALUE : sortNo1;
                Integer sortNo2 = (Integer)configFileAndSortNo.get(o2.getFilename());
                sortNo2 = sortNo2 == null ? Integer.MAX_VALUE : sortNo2;
                return sortNo1.compareTo(sortNo2);
            }
        });
        return sourceList.toArray(new Resource[0]);
    }

    private Resource[] filte(Resource[] source) {
        ArrayList<Resource> dubboServerConfList = new ArrayList<Resource>();
        ArrayList<Resource> dubboClientConfList = new ArrayList<Resource>();
        Resource redisSource = null;
        for (int i = 0; i < source.length; ++i) {
            String fileName = source[i].getFilename();
            if (fileName.contains("spring-dubbo") && fileName.contains("provider")) {
                dubboServerConfList.add(source[i]);
            }
            if (fileName.contains("spring-dubbo") && fileName.contains("consumer")) {
                dubboClientConfList.add(source[i]);
            }
            if (!fileName.contains("spring-redis")) continue;
            redisSource = source[i];
        }
        try {
            int i;
            source = this.removeRepeatResources(source);
            Properties properties = this.loadConfProperties();
            Boolean isDubboServer = Boolean.valueOf(properties.getProperty("dubbo.is.server", "false").trim());
            Boolean isDubboClient = Boolean.valueOf(properties.getProperty("dubbo.is.client", "false").trim());
            Boolean isRedisCacheEnable = Boolean.valueOf(properties.getProperty("cache.redis.is.enable", "true").trim());
            if (!isDubboServer.booleanValue()) {
                for (i = 0; i < dubboServerConfList.size(); ++i) {
                    source = (Resource[])ArrayUtils.removeElement((Object[])source, dubboServerConfList.get(i));
                }
            }
            if (!isDubboClient.booleanValue()) {
                for (i = 0; i < dubboClientConfList.size(); ++i) {
                    source = (Resource[])ArrayUtils.removeElement((Object[])source, dubboClientConfList.get(i));
                }
            }
            if (!isRedisCacheEnable.booleanValue() && redisSource != null) {
                source = (Resource[])ArrayUtils.removeElement((Object[])source, (Object)redisSource);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.logger.warn((Object)"\u8fc7\u6ee4spring\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return source;
        }
        return source;
    }

    private Properties loadConfProperties() throws FileNotFoundException, IOException, URISyntaxException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("//conf.properties");
        Properties properties = new Properties();
        properties.load(in);
        return properties;
    }

    private Resource[] removeRepeatResources(Resource[] resources) throws IOException {
        ArrayList<String> namesOfRepeat = new ArrayList<String>();
        ArrayList<String> namesOfNoneRepeat = new ArrayList<String>();
        for (Resource resource : resources) {
            String fileName = resource.getFilename();
            if (!namesOfNoneRepeat.contains(fileName)) {
                namesOfNoneRepeat.add(resource.getFilename());
                continue;
            }
            namesOfRepeat.add(fileName);
        }
        if (CollectionUtils.isEmpty(namesOfRepeat)) {
            return resources;
        }
        ArrayList<Resource> repeatResources = new ArrayList<Resource>();
        for (String fileName : namesOfRepeat) {
            for (Resource resource : resources) {
                if (!fileName.equals(resource.getFilename()) || !resource.getURI().toString().contains(".jar!")) continue;
                repeatResources.add(resource);
            }
        }
        for (Resource resource : repeatResources) {
            resources = (Resource[])ArrayUtils.removeElement((Object[])resources, (Object)resource);
        }
        return resources;
    }
}

