/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.command;

import com.els.base.company.entity.CompanySapRelation;
import com.els.base.company.entity.CompanySapRelationExample;
import com.els.base.company.service.CompanySapRelationService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.entity.MaterialFile;
import com.els.base.material.entity.MaterialFileNotice;
import com.els.base.material.service.MaterialFileNoticeService;
import com.els.base.material.utils.BusinessMaterialTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class CreateMaterialFileNoticeCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<MaterialFile> materialFileList;
    private List<String> supCompanySapCodeList;

    public CreateMaterialFileNoticeCmd(String supCompanySapCode, List<MaterialFile> materialFiles) {
        this.materialFileList = materialFiles;
        this.supCompanySapCodeList = Arrays.asList(supCompanySapCode);
    }

    public CreateMaterialFileNoticeCmd(List<String> supCompanySapCodeList, List<MaterialFile> materialFiles) {
        this.materialFileList = materialFiles;
        this.supCompanySapCodeList = supCompanySapCodeList;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.vaild();
        CompanySapRelationExample example = new CompanySapRelationExample();
        example.createCriteria().andCompanySapCodeIn(this.supCompanySapCodeList);
        List companyList = ((CompanySapRelationService)SpringContextHolder.getOneBean(CompanySapRelationService.class)).queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)companyList, (String)String.format("\u4f9b\u5e94\u5546sapCode[%s] \u4e0d\u5b58\u5728", StringUtils.join(this.supCompanySapCodeList, (String)",")));
        List<MaterialFileNotice> list = companyList.stream().flatMap(company -> this.materialFileList.stream().map(materialFile -> this.build((MaterialFile)materialFile, (CompanySapRelation)company))).collect(Collectors.toList());
        MaterialFileNoticeService materialFileNoticeService = (MaterialFileNoticeService)SpringContextHolder.getOneBean(MaterialFileNoticeService.class);
        materialFileNoticeService.addAll(list);
        this.sendMessage(list);
        return null;
    }

    public void sendMessage(List<MaterialFileNotice> list) {
        Map<String, List<MaterialFileNotice>> collect = list.stream().collect(Collectors.groupingBy(MaterialFileNotice::getSupCompanyId));
        for (Map.Entry<String, List<MaterialFileNotice>> entry : collect.entrySet()) {
            User user = ((CompanyUserRefService)SpringContextHolder.getOneBean(CompanyUserRefService.class)).queryMainUserOfCompany(entry.getKey());
            List<MaterialFileNotice> materialFileNoticeList = collect.get(entry.getKey());
            List materialCodeList = materialFileNoticeList.stream().map(MaterialFileNotice::getMaterialCode).distinct().collect(Collectors.toList());
            String defaultMsg = String.format("\u60a8\u6536\u5230\u4e86\u65b0\u7684\u7269\u6599\u8bbe\u8ba1\u6587\u6863,\u7269\u6599\u7f16\u7801\u5305\u542b\u3010" + String.join((CharSequence)",", materialCodeList) + "\u3011", new Object[0]);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("defaultMsg", defaultMsg);
            Message message = Message.init(data).setCompanyCode(materialFileNoticeList.get(0).getSupCompanySapCode()).setSenderId("1").addReceiverId(user.getId()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(BusinessMaterialTypeEnum.MATERIAL_FILE_TO_SUPPLIER.getCode());
            MessageSendUtils.sendMessage((Message)message);
        }
    }

    private void vaild() {
        Assert.isNotEmpty(this.materialFileList, (String)"\u6587\u6863\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(this.supCompanySapCodeList, (String)"\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private MaterialFileNotice build(MaterialFile materialFile, CompanySapRelation companySapRelation) {
        MaterialFileNotice notice = new MaterialFileNotice();
        BeanUtils.copyProperties((Object)materialFile, (Object)notice);
        notice.setId(UUIDGenerator.generateUUID());
        notice.setCreateTime(new Date());
        notice.setSendTime(new Date());
        notice.setConfirmStatus(Constant.NO_INT);
        notice.setSupCompanyId(companySapRelation.getCompanyId());
        notice.setSupCompanyName(companySapRelation.getCompanyFullName());
        notice.setSupCompanySapCode(companySapRelation.getCompanySapCode());
        notice.setSupCompanySrmCode(companySapRelation.getCompanyCode());
        return notice;
    }
}

