/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.DepartmentMapper;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultDepartmentService")
public class DepartmentServiceImpl
implements DepartmentService {
    @Resource
    protected DepartmentMapper departmentMapper;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserService userService;

    @Override
    @CacheEvict(value={"department"}, allEntries=true)
    public void addObj(Department t) {
        t.setIsEnable(Constant.YES_INT);
        this.departmentMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"department"}, allEntries=true)
    public void insertObj(Department t) {
        this.departmentMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"department"}, allEntries=true)
    public void deleteObjById(String id) {
        this.departmentMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"department"}, allEntries=true)
    public void modifyObj(Department t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.departmentMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public Department queryObjById(String id) {
        return this.departmentMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> queryAllObjByExample(DepartmentExample example) {
        return this.departmentMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public PageView<Department> queryObjByPage(DepartmentExample example) {
        PageView<Department> pageView = example.getPageView();
        pageView.setQueryResult(this.departmentMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public PageView<User> queryUsersInDepartmentByPage(int pageNo, int pageSize, String departmentId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andDepartmentIdEqualTo(departmentId);
        List allUser = this.companyUserRefService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(allUser)) {
            return new PageView<User>(pageNo, pageSize);
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        for (CompanyUserRef ref : allUser) {
            userIdList.add(ref.getUserId());
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andIdIn(userIdList).andIsEnableEqualTo(Constant.YES_INT);
        userExample.setPageView(new PageView<User>(pageNo, pageSize));
        return this.userService.queryObjByPage(userExample);
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public List<Department> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        DepartmentExample example = new DepartmentExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<Department> departmentList = this.departmentMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(departmentList)) {
            return null;
        }
        for (Department department : departmentList) {
            department.setSubDepList(this.queryByParentId(department.getId()));
        }
        return departmentList;
    }

    @Override
    @CacheEvict(value={"department", "userService"}, allEntries=true)
    public void addUserIntoDepartment(String userId, String departmentId) {
        Department department = (Department)((DepartmentService)SpringContextHolder.getOneBean(DepartmentService.class)).queryObjById(departmentId);
        if (department == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        CompanyUserRefExample userRefExample = new CompanyUserRefExample();
        userRefExample.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample(userRefExample);
        if (CollectionUtils.isEmpty(refList)) {
            CompanyUserRef ref = new CompanyUserRef();
            ref.setUserId(userId);
            ref.setCompanyId(department.getCompanyId());
            ref.setDepartmentId(departmentId);
            ref.setProjectId(department.getProjectId());
            this.companyUserRefService.addObj(ref);
        } else {
            if (refList.size() > 1) {
                throw new CommonException("\u6570\u636e\u5df2\u5b58\u5728", "base_is_exists", "\u7528\u6237");
            }
            CompanyUserRef ref = (CompanyUserRef)refList.get(0);
            if (!department.getCompanyId().equals(ref.getCompanyId())) {
                throw new CommonException("\u7528\u6237\u5df2\u5206\u914d", "user_assigned");
            }
            CompanyUserRef tmp = new CompanyUserRef();
            tmp.setId(ref.getId());
            tmp.setDepartmentId(departmentId);
            this.companyUserRefService.modifyObj(tmp);
        }
    }

    @Override
    @Cacheable(value={"department"}, keyGenerator="redisKeyGenerator")
    public Department queryDepartmentOfUser(String userId) {
        CompanyUserRefExample example = new CompanyUserRefExample();
        example.createCriteria().andUserIdEqualTo(userId);
        List refList = this.companyUserRefService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(refList)) {
            return null;
        }
        String departmentId = ((CompanyUserRef)refList.get(0)).getDepartmentId();
        if (StringUtils.isBlank((String)departmentId)) {
            return null;
        }
        return this.queryObjById(departmentId);
    }
}

