/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.SupplyGoodsRefMapper;
import com.els.base.company.entity.SupplyGoodsRef;
import com.els.base.company.entity.SupplyGoodsRefExample;
import com.els.base.company.service.SupplyGoodsRefService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultSupplyGoodsRefService")
public class SupplyGoodsRefServiceImpl
implements SupplyGoodsRefService {
    @Resource
    protected SupplyGoodsRefMapper supplyGoodsRefMapper;

    @Override
    @CacheEvict(value={"supplyGoodsRef"}, allEntries=true)
    public void addObj(SupplyGoodsRef t) {
        String supplierSapCode = t.getSupplerSapCode();
        String supplyTypeSapCode = t.getSupplySapCode();
        SupplyGoodsRefExample example = new SupplyGoodsRefExample();
        SupplyGoodsRefExample.Criteria criteria = example.createCriteria();
        criteria.andSupplerSapCodeEqualTo(supplierSapCode);
        criteria.andSupplySapCodeEqualTo(supplyTypeSapCode);
        List<SupplyGoodsRef> list = this.queryAllObjByExample(example);
        if (list != null && !list.isEmpty()) {
            return;
        }
        this.supplyGoodsRefMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"supplyGoodsRef"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplyGoodsRefMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supplyGoodsRef"}, allEntries=true)
    public void modifyObj(SupplyGoodsRef t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supplyGoodsRefMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplyGoodsRef"}, keyGenerator="redisKeyGenerator")
    public SupplyGoodsRef queryObjById(String id) {
        return this.supplyGoodsRefMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"supplyGoodsRef"}, keyGenerator="redisKeyGenerator")
    public List<SupplyGoodsRef> queryAllObjByExample(SupplyGoodsRefExample example) {
        return this.supplyGoodsRefMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplyGoodsRef"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplyGoodsRef> queryObjByPage(SupplyGoodsRefExample example) {
        PageView<SupplyGoodsRef> pageView = example.getPageView();
        pageView.setQueryResult(this.supplyGoodsRefMapper.selectByExampleByPage(example));
        return pageView;
    }
}

